/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simplegraves;

import com.flummidill.libs.json.JSONArray;
import com.flummidill.libs.json.JSONObject;
import com.flummidill.simplegraves.BlockBreakListener;
import com.flummidill.simplegraves.CommandHandler;
import com.flummidill.simplegraves.DatabaseWorker;
import com.flummidill.simplegraves.GraveManager;
import com.flummidill.simplegraves.GraveProtector;
import com.flummidill.simplegraves.PlayerDeathListener;
import com.flummidill.simplegraves.PlayerJoinListener;
import com.flummidill.simplegraves.TabCompleter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SimpleGraves
extends JavaPlugin {
    private GraveManager manager;
    private DatabaseWorker dbWorker;
    private PlayerJoinListener playerJoinListener;
    private PlayerDeathListener playerDeathListener;
    private BlockBreakListener blockBreakListener;
    private GraveProtector graveProtector;

    public void onEnable() {
        this.getLogger().info("~ Created by Flummidill ~");
        this.getLogger().info("Initializing Database-Worker...");
        this.dbWorker = new DatabaseWorker();
        this.getLogger().info("Initializing Grave-Manager...");
        this.manager = new GraveManager(this, this.dbWorker);
        this.getLogger().info("Initializing Event Listeners...");
        this.initializeEventListeners();
        this.getLogger().info("Loading Configuration...");
        this.loadConfig();
        this.getLogger().info("Registering Commands...");
        this.registerCommands();
        this.getLogger().info("Checking for Updates...");
        this.checkForUpdates();
        BukkitRunnable onLoad = new BukkitRunnable(){

            public void run() {
                SimpleGraves.this.executeConsoleCommand("gamerule keepInventory true");
            }
        };
        onLoad.runTaskLater((Plugin)this, 1L);
    }

    public void initializeEventListeners() {
        this.playerJoinListener = new PlayerJoinListener(this, this.manager);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerJoinListener, (Plugin)this);
        this.playerDeathListener = new PlayerDeathListener(this, this.manager);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerDeathListener, (Plugin)this);
        this.blockBreakListener = new BlockBreakListener(this, this.manager);
        this.getServer().getPluginManager().registerEvents((Listener)this.blockBreakListener, (Plugin)this);
        this.graveProtector = new GraveProtector(this, this.manager);
        this.getServer().getPluginManager().registerEvents((Listener)this.graveProtector, (Plugin)this);
    }

    private void loadConfig() {
        boolean graveStealing = this.getConfig().getBoolean("grave-stealing", true);
        int maxStoredXP = this.getConfig().getInt("max-stored-xp", 25);
        boolean deleteVanishingItems = this.getConfig().getBoolean("delete-vanishing-items", false);
        boolean nonGravePlayerHeadWaterProtection = this.getConfig().getBoolean("non-grave-player-head-water-protection", true);
        String configVersion = this.getConfig().getString("config-version", "1.0.0");
        String currentVersion = this.getDescription().getVersion();
        this.saveResource("config.yml", true);
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        if (!graveStealing) {
            this.blockBreakListener.disableGraveStealing();
        }
        config.set("grave-stealing", (Object)graveStealing);
        if (maxStoredXP < 0) {
            this.getLogger().warning("Configuration Error: \"max-stored-xp\" was configured incorrectly and reset to 25.");
            maxStoredXP = 25;
        }
        this.manager.setMaxStordXP(maxStoredXP);
        config.set("max-stored-xp", (Object)maxStoredXP);
        if (deleteVanishingItems) {
            this.manager.deleteVanishingItems();
        }
        config.set("delete-vanishing-items", (Object)deleteVanishingItems);
        if (!nonGravePlayerHeadWaterProtection) {
            this.graveProtector.disableNonGravePlayerHeadWaterProtection();
        }
        config.set("non-grave-player-head-water-protection", (Object)nonGravePlayerHeadWaterProtection);
        if ("1.0.0".equals(configVersion) || this.isNewerVersion(configVersion, "1.0.0")) {
            if (this.isOlderVersion(configVersion, currentVersion)) {
                this.getLogger().info("Configuration Update: \"config-version\" has been updated to \"" + currentVersion + "\".");
                configVersion = currentVersion;
            }
        } else {
            this.getLogger().warning("Configuration Error: \"config-version\" was configured incorrectly and reset to \"" + currentVersion + "\".");
            configVersion = currentVersion;
        }
        config.set("config-version", (Object)configVersion);
        this.saveConfig();
    }

    public void registerCommands() {
        CommandHandler commandHandler = new CommandHandler(this, this.manager);
        TabCompleter tabCompleter = new TabCompleter(this, this.manager);
        this.getCommand("graveinfo").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("graveadmin").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("graveinfo").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getCommand("graveadmin").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
    }

    private void checkForUpdates() {
        String[] latestVersion = this.getLatestVersion().split("\\|", 2);
        String currentVersion = this.getDescription().getVersion();
        if (!"error".equals(latestVersion[0])) {
            if (this.isNewerVersion(latestVersion[0], currentVersion)) {
                this.getLogger().warning("A new Version of SimpleGraves is available: " + latestVersion[0]);
                this.playerJoinListener.setUpdateAvailable(true);
            } else {
                this.getLogger().info("No new Updates available.");
            }
        } else {
            this.getLogger().warning("Failed to Check for Updates!\n" + latestVersion[1]);
        }
    }

    public String getLatestVersion() {
        String apiUrl = "https://api.modrinth.com/v2/project/simple_graves/version";
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Accept", "application/json").build();
            try {
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    JSONArray jsonArray = new JSONArray(response.body());
                    if (!jsonArray.isEmpty()) {
                        JSONObject latestVersion = jsonArray.getJSONObject(0);
                        String string = latestVersion.getString("version_number");
                        return string;
                    }
                    String string = "error|No Version Data Found: Project has no Versions on Modrinth";
                    return string;
                }
                String jsonArray = "error|No Version Data Found: Failed to Connect to Modrinth API";
                return jsonArray;
            }
            catch (IOException | InterruptedException e) {
                this.getLogger().warning("Failed to check for Updates!");
                StringWriter stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                String string = "error|" + String.valueOf(stackTrace);
                return string;
            }
        }
    }

    public boolean isNewerVersion(String comparingVersion, String referenceVersion) {
        String[] comparingVersionParts = comparingVersion.split("\\.");
        String[] referenceVersionParts = referenceVersion.split("\\.");
        for (int i = 0; i < 3; ++i) {
            int referenceVersionPart;
            int comparingVersionPart = i < comparingVersionParts.length ? Integer.parseInt(comparingVersionParts[i]) : 0;
            int n = referenceVersionPart = i < referenceVersionParts.length ? Integer.parseInt(referenceVersionParts[i]) : 0;
            if (comparingVersionPart > referenceVersionPart) {
                return true;
            }
            if (comparingVersionPart >= referenceVersionPart) continue;
            return false;
        }
        return false;
    }

    public boolean isOlderVersion(String comparingVersion, String referenceVersion) {
        String[] comparingVersionParts = comparingVersion.split("\\.");
        String[] referenceVersionParts = referenceVersion.split("\\.");
        for (int i = 0; i < 3; ++i) {
            int referenceVersionPart;
            int comparingVersionPart = i < comparingVersionParts.length ? Integer.parseInt(comparingVersionParts[i]) : 0;
            int n = referenceVersionPart = i < referenceVersionParts.length ? Integer.parseInt(referenceVersionParts[i]) : 0;
            if (comparingVersionPart < referenceVersionPart) {
                return true;
            }
            if (comparingVersionPart <= referenceVersionPart) continue;
            return false;
        }
        return false;
    }

    public void onDisable() {
        this.dbWorker.shutdown();
    }

    public void executeConsoleCommand(String cmd) {
        this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), cmd);
    }
}

