/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simplegraves;

import com.flummidill.simplegraves.GraveManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TabCompleter
implements org.bukkit.command.TabCompleter {
    private final GraveManager graveManager;

    public TabCompleter(GraveManager graveManager) {
        this.graveManager = graveManager;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (sender instanceof Player) {
            String cmd;
            Player player = (Player)sender;
            UUID uuid = player.getUniqueId();
            this.graveManager.saveOfflinePlayer(uuid, player.getName());
            switch (cmd = command.getName().toLowerCase()) {
                case "graveinfo": {
                    return this.autocompleteGraveInfo(player, args);
                }
                case "graveadmin": {
                    return this.autocompleteGraveAdmin(player, args);
                }
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private List<String> autocompleteGraveInfo(Player player, String[] args) {
        if (args.length == 1) {
            return this.graveManager.getGraveNumberList(player.getUniqueId());
        }
        return Collections.emptyList();
    }

    private List<String> autocompleteGraveAdmin(Player sender, String[] args) {
        if (args.length == 1) {
            String prefix = args[0].toLowerCase();
            List<String> subcommands = Arrays.asList("go", "list", "info", "remove");
            if (prefix.isEmpty()) {
                return subcommands;
            }
            return this.filterStringsByPrefix(subcommands, prefix);
        }
        if (args.length == 2) {
            String subcommand = args[0].toLowerCase();
            String prefix = args[1].toLowerCase();
            ArrayList<String> playerNames = new ArrayList<String>();
            for (Object p : Bukkit.getOnlinePlayers()) {
                String name = p.getName();
                if (playerNames.contains(name)) continue;
                playerNames.add(name);
            }
            List<String> offlinePlayerNames = this.graveManager.getOfflinePlayerNameList();
            for (String name : offlinePlayerNames) {
                if (playerNames.contains(name)) continue;
                playerNames.add(name);
            }
            if (prefix.isEmpty()) {
                return playerNames;
            }
            return this.filterStringsByPrefix(playerNames, prefix);
        }
        if (args.length == 3) {
            UUID playerUUID;
            String subcommand = args[0].toLowerCase();
            String playerName = args[1];
            Player target = Bukkit.getPlayerExact((String)playerName);
            if (target != null) {
                playerUUID = target.getUniqueId();
            } else if (this.graveManager.getOfflinePlayerUUID(playerName) != null) {
                playerUUID = this.graveManager.getOfflinePlayerUUID(playerName);
            } else {
                return Collections.emptyList();
            }
            if (subcommand.equals("list")) {
                return Collections.emptyList();
            }
            List<String> graveNumberList = this.graveManager.getGraveNumberList(playerUUID);
            if (graveNumberList.isEmpty()) {
                return Collections.emptyList();
            }
            return graveNumberList;
        }
        return Collections.emptyList();
    }

    private List<String> filterStringsByPrefix(List<String> stringList, String prefix) {
        if (prefix == null || prefix.isEmpty() || stringList == null || stringList.isEmpty()) {
            return Collections.emptyList();
        }
        return stringList.stream().filter(string -> string.toLowerCase().startsWith(prefix.toLowerCase())).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
    }
}

