/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simplegraves;

import com.flummidill.simplegraves.GraveManager;
import com.flummidill.simplegraves.SimpleGraves;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor {
    private final SimpleGraves plugin;
    private final GraveManager manager;

    public CommandHandler(SimpleGraves plugin, GraveManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly Players can run this Command!");
            return false;
        }
        Player player = (Player)sender;
        this.manager.saveOfflinePlayer(player.getUniqueId(), player.getName());
        switch (cmd = command.getName().toLowerCase()) {
            case "graveinfo": {
                if (!player.hasPermission("simplegraves.use")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                    return false;
                }
                if (args.length != 1) {
                    player.sendMessage("Usage: /graveinfo <number>");
                    return false;
                }
                return this.handleGraveInfo(player, args);
            }
            case "graveadmin": {
                if (!player.hasPermission("simplegraves.admin")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                    return false;
                }
                if (args.length < 1 || args.length > 3) {
                    player.sendMessage("Usage: /graveadmin <go|list|info|delete> [<player>] [<number>]");
                    return false;
                }
                return this.handleGraveAdmin(player, args);
            }
        }
        return false;
    }

    private boolean handleGraveInfo(Player player, String[] args) {
        int graveNumber;
        UUID targetUUID = player.getUniqueId();
        if (!this.manager.graveExistsUUID(targetUUID, graveNumber = Integer.parseInt(args[0]))) {
            player.sendMessage("\u00a7cYou don't have a Grave with Number #" + graveNumber);
            return false;
        }
        Location graveLocation = this.manager.getGraveLocation(targetUUID, graveNumber);
        if (graveLocation == null || graveLocation.getWorld() == null) {
            player.sendMessage("\u00a7cFailed to retrieve the Grave Location");
            return false;
        }
        String worldName = "The Overworld";
        switch (graveLocation.getWorld().getName()) {
            case "world": {
                worldName = "The Overworld";
                break;
            }
            case "world_nether": {
                worldName = "The Nether";
                break;
            }
            case "world_the_end": {
                worldName = "The End";
            }
        }
        player.sendMessage("\u00a7aGrave #" + graveNumber + " is Located at:\n\u00a79World: \u00a7c" + worldName + "\n\u00a79X: \u00a7c" + Math.floor(graveLocation.getX()) + "\n\u00a79Y: \u00a7c" + Math.floor(graveLocation.getY()) + "\n\u00a79Z: \u00a7c" + Math.floor(graveLocation.getZ()));
        return true;
    }

    private boolean handleGraveAdmin(Player sender, String[] args) {
        UUID targetUUID;
        Player targetPlr;
        String subcommand = args[0].toLowerCase();
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /graveadmin " + subcommand + " <player> [<number>]");
            return false;
        }
        String targetName = args[1];
        int graveNumber = 1;
        if (args.length == 3) {
            try {
                graveNumber = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cInvalid grave number.");
                return false;
            }
        }
        if ((targetPlr = Bukkit.getPlayerExact((String)targetName)) != null) {
            targetUUID = targetPlr.getUniqueId();
        } else {
            targetUUID = this.manager.getOfflinePlayerUUID(targetName);
            if (targetUUID == null) {
                sender.sendMessage("\u00a7cPlayer '" + targetName + "' not found.");
                return false;
            }
        }
        switch (subcommand) {
            case "go": {
                if (!this.manager.graveExistsUUID(targetUUID, graveNumber)) {
                    sender.sendMessage("\u00a7c" + targetName + " doesn't have a Grave with Number #" + graveNumber);
                    return false;
                }
                Location tpLoc = this.manager.getGraveLocation(targetUUID, graveNumber);
                if (tpLoc != null) {
                    sender.teleport(tpLoc);
                    sender.sendMessage("\u00a7aTeleported to " + targetName + "'s Grave #" + graveNumber);
                    return true;
                }
                sender.sendMessage("\u00a7cFailed to retrieve Grave Location.");
                return false;
            }
            case "list": {
                List<String> graveList = this.manager.getGraveNumberList(targetUUID);
                if (graveList.isEmpty()) {
                    sender.sendMessage("\u00a7c" + this.manager.getOfflinePlayerName(targetUUID) + " currently no Graves.");
                } else {
                    sender.sendMessage("\u00a7a" + targetName + "'s Grave List:");
                    for (String graveNum : graveList) {
                        sender.sendMessage("\u00a7c#" + graveNum);
                    }
                }
                return true;
            }
            case "info": {
                if (!this.manager.graveExistsUUID(targetUUID, graveNumber)) {
                    sender.sendMessage("\u00a7c" + targetName + " doesn't have a Grave with the number " + graveNumber + ".");
                    return false;
                }
                Location graveLocation = this.manager.getGraveLocation(targetUUID, graveNumber);
                if (graveLocation == null || graveLocation.getWorld() == null) {
                    sender.sendMessage("\u00a7cFailed to retrieve the grave location or world.");
                    return false;
                }
                String worldName = "The Overworld";
                switch (graveLocation.getWorld().getName()) {
                    case "world": {
                        worldName = "The Overworld";
                        break;
                    }
                    case "world_nether": {
                        worldName = "The Nether";
                        break;
                    }
                    case "world_the_end": {
                        worldName = "The End";
                    }
                }
                sender.sendMessage("\u00a7a" + targetName + "'s Grave #" + graveNumber + " is Located at:\n\u00a79World: \u00a7c" + worldName + "\n\u00a79X: \u00a7c" + Math.floor(graveLocation.getX()) + "\n\u00a79Y: \u00a7c" + Math.floor(graveLocation.getY()) + "\n\u00a79Z: \u00a7c" + Math.floor(graveLocation.getZ()));
                return true;
            }
            case "remove": {
                if (!this.manager.graveExistsUUID(targetUUID, graveNumber)) {
                    sender.sendMessage("\u00a7c" + targetName + " doesn't have a Grave with Number #" + graveNumber);
                    return false;
                }
                this.manager.removeGrave(targetUUID, graveNumber);
                sender.sendMessage("\u00a7aRemoved " + targetName + "'s Grave #" + graveNumber);
                return true;
            }
        }
        sender.sendMessage("Usage: /graveadmin <go|list|info|remove> [<player>] [<number>]");
        return false;
    }
}

