/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.uncraftingtable;

import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.gui.SimpleScreenHandler;
import net.pitan76.mcpitanlib.api.gui.args.SlotClickEvent;
import net.pitan76.mcpitanlib.api.gui.slot.CompatibleSlot;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.ScreenHandlerUtil;
import net.pitan76.mcpitanlib.api.util.SlotUtil;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import net.pitan76.mcpitanlib.api.util.inventory.CompatPlayerInventory;
import net.pitan76.uncraftingtable.BookInventory;
import net.pitan76.uncraftingtable.BookSlot;
import net.pitan76.uncraftingtable.Config;
import net.pitan76.uncraftingtable.InsertSlot;
import net.pitan76.uncraftingtable.OutSlot;
import net.pitan76.uncraftingtable.UncraftingInventory;
import net.pitan76.uncraftingtable.UncraftingTable;

public class UncraftingScreenHandler
extends SimpleScreenHandler {
    private final UncraftingInventory uncraftingInventory = new UncraftingInventory();
    public final BookInventory bookInventory = new BookInventory();
    public boolean hasBookSlot = true;

    public UncraftingScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, new CompatPlayerInventory(playerInventory));
    }

    public UncraftingScreenHandler(int syncId, CompatPlayerInventory playerInventory) {
        super((MenuType)UncraftingTable.UNCRAFTING_TABLE_MENU.get(), syncId);
        int x;
        int y;
        Player player = playerInventory.getPlayer();
        InsertSlot insertSlot = new InsertSlot((Container)this.uncraftingInventory, 0, 36, 35, player);
        this.uncraftingInventory.setInsertSlot(insertSlot);
        this.callAddSlot((Slot)insertSlot);
        int i = 0;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.callAddSlot((Slot)new OutSlot((Container)this.uncraftingInventory, ++i, 94 + x * 18, 17 + y * 18, insertSlot));
            }
        }
        this.hasBookSlot = Config.config.getBooleanOrDefault("restore_enchantment_book", true);
        if (this.hasBookSlot) {
            BookSlot bookSlot = new BookSlot((Container)this.bookInventory, 0, 8, 35, player);
            this.bookInventory.setBookSlot(bookSlot);
            insertSlot.bookSlot = bookSlot;
            this.callAddSlot((Slot)bookSlot);
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.callAddSlot((Slot)new CompatibleSlot((Container)playerInventory.getRaw(), x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (y = 0; y < 9; ++y) {
            this.callAddSlot((Slot)new CompatibleSlot((Container)playerInventory.getRaw(), y, 8 + y * 18, 142));
        }
    }

    public static void init() {
    }

    public void onSlotClick(SlotClickEvent e) {
        int slotIndex = e.getSlot();
        if (!e.isPickupAction() || ScreenHandlerUtil.getSlots((AbstractContainerMenu)this).size() <= slotIndex || slotIndex < 0) {
            super.onSlotClick(e);
            return;
        }
        Slot slot = ScreenHandlerUtil.getSlot((AbstractContainerMenu)this, (int)slotIndex);
        if (!(slot instanceof OutSlot)) {
            super.onSlotClick(e);
            return;
        }
        this.quickMoveOverride(e.getPlayer(), slotIndex);
    }

    public ItemStack quickMoveOverride(Player player, int index) {
        ItemStack newStack = ItemStackUtil.empty();
        Slot slot = ScreenHandlerUtil.getSlot((AbstractContainerMenu)this, (int)index);
        if (SlotUtil.hasStack((Slot)slot)) {
            int needXp;
            if (slot instanceof OutSlot && (needXp = Config.config.getIntOrDefault("consume_xp", 0)) != 0 && !player.isCreative() && needXp > player.getTotalExperience()) {
                player.sendMessage((Component)TextUtil.translatable((String)"message.uncraftingtable76.not_enough_xp"));
                return ItemStackUtil.empty();
            }
            ItemStack originalStack = SlotUtil.getStack((Slot)slot);
            newStack = ItemStackUtil.copy((ItemStack)originalStack);
            if (index < this.uncraftingInventory.getSize()) {
                if (!this.callInsertItem(originalStack, this.uncraftingInventory.getSize(), ScreenHandlerUtil.getSlots((AbstractContainerMenu)this).size(), true)) {
                    return ItemStackUtil.empty();
                }
            } else {
                if (!this.callInsertItem(originalStack, 0, 1, false)) {
                    return ItemStackUtil.empty();
                }
                this.uncraftingInventory.insertSlot.updateOutSlot(this.uncraftingInventory.insertSlot.callGetStack());
            }
            if (ItemStackUtil.isEmpty((ItemStack)originalStack)) {
                SlotUtil.setStack((Slot)slot, (ItemStack)ItemStackUtil.empty());
            } else {
                SlotUtil.markDirty((Slot)slot);
            }
        }
        return newStack;
    }

    public boolean canDragTo(Slot slot) {
        return !(slot instanceof OutSlot) && super.canDragTo(slot);
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.mayPlace(stack);
    }

    public void close(Player player) {
        this.uncraftingInventory.onClose(player);
        this.bookInventory.onClose(player);
        super.close(player);
    }
}

