/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.uncraftingtable;

import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.util.recipe.RecipeUtil;
import net.pitan76.mcpitanlib.midohra.recipe.CraftingRecipe;
import net.pitan76.mcpitanlib.midohra.recipe.ShapedRecipe;
import net.pitan76.mcpitanlib.midohra.recipe.ShapelessRecipe;
import net.pitan76.mcpitanlib.midohra.recipe.entry.RecipeEntry;
import net.pitan76.mcpitanlib.midohra.recipe.input.CraftingRecipeInputOrInventory;
import net.pitan76.mcpitanlib.midohra.world.ServerWorld;
import net.pitan76.mcpitanlib.midohra.world.World;
import net.pitan76.uncraftingtable.UncraftingTable;
import org.jetbrains.annotations.Nullable;

public class CraftingRecipeUtil {
    @Nullable
    public static ItemStack getOutput(CraftingRecipe recipe, CraftingRecipeInputOrInventory input, Level world) {
        if (recipe instanceof ShapedRecipe || recipe instanceof ShapelessRecipe) {
            return recipe.getOutput(input, world);
        }
        try {
            return recipe.getOutput(input, world);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String id = "Unknown recipe";
            for (RecipeEntry entry : RecipeUtil.getRecipeEntries((World)World.of((Level)world))) {
                if (entry.getRawRecipe() != recipe.getRaw()) continue;
                id = entry.getId().toString();
                break;
            }
            UncraftingTable.INSTANCE.logger.error(e.getMessage() + ": " + id);
            return null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static Collection<CraftingRecipe> getCraftingRecipes(ServerWorld world) {
        try {
            return RecipeUtil.getCraftingRecipes((World)world).stream().map(recipe -> {
                if (recipe instanceof ShapedRecipe || recipe instanceof ShapelessRecipe) {
                    return recipe;
                }
                if (recipe.getRaw() instanceof net.minecraft.world.item.crafting.ShapedRecipe) {
                    return ShapedRecipe.of((net.minecraft.world.item.crafting.ShapedRecipe)((net.minecraft.world.item.crafting.ShapedRecipe)recipe.getRaw()));
                }
                if (recipe.getRaw() instanceof net.minecraft.world.item.crafting.ShapelessRecipe) {
                    return ShapelessRecipe.of((net.minecraft.world.item.crafting.ShapelessRecipe)((net.minecraft.world.item.crafting.ShapelessRecipe)recipe.getRaw()));
                }
                return recipe;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            return RecipeUtil.getCraftingRecipes((World)world);
        }
    }
}

