/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.spawnable.init;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.refractionapi.refraction.events.RefractionEvents;
import net.zeus.spawnable.Spawnable;
import net.zeus.spawnable.init.SpawnableData;
import net.zeus.spawnable.init.SpawnableHolder;

public class Manager {
    private static final Int2ObjectArrayMap<SpawnableHolder> holders = new Int2ObjectArrayMap();

    private static void passData(CompoundTag tag) {
        if (!holders.isEmpty()) {
            return;
        }
        ListTag list = tag.m_128437_("holders", 10);
        for (Tag tag1 : list) {
            SpawnableHolder holder = SpawnableHolder.fromTag((CompoundTag)tag1);
            if (holder == null) continue;
            Manager.addHolder(holder);
        }
    }

    public static void addHolder(SpawnableHolder holder) {
        int size = holders.size();
        holders.put(size, (Object)holder);
        holder.id().set((Object)size);
    }

    public static void removeHolder(int id) {
        if (!holders.containsKey(id)) {
            return;
        }
        holders.remove(id);
        Int2ObjectArrayMap copy = new Int2ObjectArrayMap(holders);
        holders.clear();
        copy.values().forEach(Manager::addHolder);
    }

    public static SpawnableHolder getHolder(int id) {
        return (SpawnableHolder)holders.get(id);
    }

    public static boolean isRegistered(Holder<Biome> biomeHolder, EntityType<?> type) {
        return holders.int2ObjectEntrySet().stream().anyMatch(ent -> ((SpawnableHolder)ent.getValue()).data.f_48404_ == type && ((ResourceKey)biomeHolder.m_203543_().orElseThrow()).m_135782_().equals((Object)((SpawnableHolder)ent.getValue()).resourceName));
    }

    public static List<SpawnableHolder> getHolders() {
        return new ArrayList<SpawnableHolder>((Collection<SpawnableHolder>)holders.values());
    }

    public static List<SpawnableHolder> load(CompoundTag tag) {
        ArrayList<SpawnableHolder> out = new ArrayList<SpawnableHolder>();
        ListTag list = tag.m_128437_("holders", 10);
        for (Tag tag1 : list) {
            SpawnableHolder holder = SpawnableHolder.fromTag((CompoundTag)tag1);
            if (holder == null) continue;
            out.add(holder);
        }
        return out;
    }

    public static CompoundTag compileData() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        holders.values().forEach(h -> list.add((Object)h.toTag()));
        tag.m_128365_("holders", (Tag)list);
        return tag;
    }

    public static List<MobSpawnSettings.SpawnerData> getForBiome(MobCategory category, Holder<Biome> biomeHolder, List<MobSpawnSettings.SpawnerData> old) {
        ResourceLocation id = ((ResourceKey)biomeHolder.m_203543_().orElseThrow()).m_135782_();
        ArrayList<MobSpawnSettings.SpawnerData> data = new ArrayList<MobSpawnSettings.SpawnerData>(holders.int2ObjectEntrySet().stream().filter(val -> ((SpawnableHolder)val.getValue()).resourceName().equals((Object)id) && ((SpawnableHolder)val.getValue()).data.f_48404_.m_20674_().equals((Object)category)).map(val -> ((SpawnableHolder)val.getValue()).data()).toList());
        List<MobSpawnSettings.SpawnerData> addedData = data.stream().filter(val -> val.m_142631_().m_146281_() > 0).collect(Collectors.toList());
        old.stream().filter(d -> data.stream().noneMatch(d2 -> d2.f_48404_ == d.f_48404_)).forEach(addedData::add);
        return addedData;
    }

    public static void init() {
        Spawnable.LOGGER.info("Instantiating Spawnable");
        RefractionEvents.SERVER_STARTING.register(srv -> {
            Manager.passData(SpawnableData.load());
            Spawnable.LOGGER.info("Loaded {} holders", (Object)holders.size());
        });
        RefractionEvents.SERVER_STOPPING.register(() -> {
            SpawnableData.save(Manager.compileData());
            Spawnable.LOGGER.info("Saved {} Holders", (Object)holders.size());
            holders.clear();
        });
    }
}

