/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.spawnable.init;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.refractionapi.refraction.util.Mutable;

public class SpawnableHolder {
    ResourceLocation resourceName;
    MobSpawnSettings.SpawnerData data;
    Mutable<Integer> id;

    public SpawnableHolder(ResourceLocation resourceName, MobSpawnSettings.SpawnerData data, Mutable<Integer> id) {
        this.resourceName = resourceName;
        this.data = data;
        this.id = id;
    }

    public ResourceLocation resourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        ResourceLocation rl = ResourceLocation.m_135820_((String)resourceName);
        if (rl != null) {
            this.resourceName = rl;
        }
    }

    public void setEntityType(String entityTypeName) {
        EntityType type = EntityType.m_20632_((String)entityTypeName).orElse(null);
        if (type == null || type == this.data.f_48404_) {
            return;
        }
        this.data = new MobSpawnSettings.SpawnerData(type, this.data.m_142631_().m_146281_(), this.data.f_48405_, this.data.f_48406_);
    }

    public void setWeight(int weight) {
        this.data = new MobSpawnSettings.SpawnerData(this.data.f_48404_, weight, this.data.f_48405_, this.data.f_48406_);
    }

    public void setMinCount(int minCount) {
        this.data = new MobSpawnSettings.SpawnerData(this.data.f_48404_, this.data.m_142631_().m_146281_(), minCount, this.data.f_48406_);
    }

    public void setMaxCount(int maxCount) {
        this.data = new MobSpawnSettings.SpawnerData(this.data.f_48404_, this.data.m_142631_().m_146281_(), this.data.f_48405_, maxCount);
    }

    public MobSpawnSettings.SpawnerData data() {
        return this.data;
    }

    public Mutable<Integer> id() {
        return this.id;
    }

    public static SpawnableHolder fromTag(CompoundTag tag) {
        String resourceName = tag.m_128461_("resourceName");
        ResourceLocation rl = ResourceLocation.m_135820_((String)resourceName);
        if (rl == null) {
            return null;
        }
        String entityTypeName = tag.m_128461_("entityType");
        EntityType type = EntityType.m_20632_((String)entityTypeName).orElse(null);
        if (type == null) {
            return null;
        }
        int weight = tag.m_128451_("weight");
        int minCount = tag.m_128451_("minCount");
        int maxCount = tag.m_128451_("maxCount");
        int id = tag.m_128441_("id") ? tag.m_128451_("id") : -1;
        return new SpawnableHolder(rl, new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount), (Mutable<Integer>)new Mutable((Object)id));
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("resourceName", this.resourceName.toString());
        tag.m_128359_("entityType", EntityType.m_20613_((EntityType)this.data.f_48404_).toString());
        tag.m_128405_("weight", this.data.m_142631_().m_146281_());
        tag.m_128405_("minCount", this.data.f_48405_);
        tag.m_128405_("maxCount", this.data.f_48406_);
        tag.m_128405_("id", ((Integer)this.id.get()).intValue());
        return tag;
    }
}

