/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.spawnable.screen;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.refractionapi.refraction.feature.scheme.RScreen;
import net.refractionapi.refraction.feature.scheme.RegisterScreen;
import net.refractionapi.refraction.feature.scheme.ScreenScheme;
import net.zeus.spawnable.init.Manager;
import net.zeus.spawnable.init.SpawnableHolder;
import net.zeus.spawnable.screen.EditValuesServer;

@RegisterScreen(value=EditValuesServer.class)
public class EditValuesScreen
extends Screen
implements RScreen {
    List<SpawnableHolder> data;
    final HashMap<SpawnableHolder, List<GuiEventListener>> widgets = new HashMap();
    int scrollIndex = 0;
    Button add;
    boolean adding = false;
    List<GuiEventListener> tempWidgets;
    String resourceName = "";
    String entityType = "";
    int weight = 0;
    int minCount = 0;
    int maxCount = 0;

    public EditValuesScreen(CompoundTag tag) {
        super((Component)Component.m_237113_((String)"edit"));
        this.data = Manager.load(tag);
    }

    protected void m_7856_() {
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.header();
        this.loadWidgets();
    }

    public void header() {
        this.add = Button.m_253074_((Component)Component.m_237113_((String)"Add New"), b -> this.createTemp()).m_252794_(this.f_96543_ / 2 - 50, 5).m_253046_(100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.add);
    }

    public boolean m_6050_(double a, double b, double scroll) {
        boolean ret = super.m_6050_(a, b, scroll);
        if ((double)this.scrollIndex + scroll > 0.0) {
            return ret;
        }
        this.scrollIndex = -this.scrollIndex > this.widgets.size() - 6 && scroll < 0.0 ? this.scrollIndex : (int)((double)this.scrollIndex + scroll);
        AtomicInteger index = new AtomicInteger();
        this.widgets.forEach((sh, cmp) -> {
            for (GuiEventListener guiEventListener : cmp) {
                AbstractWidget renderable = (AbstractWidget)guiEventListener;
                renderable.m_253211_((this.scrollIndex + index.get() + 1) * 32 + 7);
            }
            index.getAndIncrement();
        });
        return ret;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.add.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        for (Renderable renderable : this.f_169369_) {
            AbstractWidget widget;
            if (!(renderable instanceof AbstractWidget) || (widget = (AbstractWidget)renderable).m_252907_() < 20) continue;
            widget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void addNew() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("resourceName", this.resourceName);
        tag.m_128359_("entityType", this.entityType);
        tag.m_128405_("weight", this.weight);
        tag.m_128405_("minCount", this.minCount);
        tag.m_128405_("maxCount", this.maxCount);
        tag.m_128379_("new", true);
        this.sendNbt(tag);
        this.tempWidgets.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.tempWidgets = null;
        this.adding = false;
    }

    public void createTemp() {
        if (this.adding) {
            return;
        }
        this.adding = true;
        this.resourceName = "";
        this.entityType = "";
        this.weight = 0;
        this.minCount = 0;
        this.maxCount = 0;
        int currY = 40 + this.widgets.size() * 40;
        int currX = this.f_96543_ / 2 - 200;
        EditBox resourceName = new EditBox(this.f_96547_, currX, currY, 100, 20, (Component)Component.m_237113_((String)this.resourceName));
        resourceName.m_257771_((Component)Component.m_237113_((String)"minecraft:plains"));
        EditBox entityType = new EditBox(this.f_96547_, currX += 105, currY, 100, 20, (Component)Component.m_237113_((String)this.entityType));
        entityType.m_257771_((Component)Component.m_237113_((String)"minecraft:cow"));
        EditBox weight = new EditBox(this.f_96547_, currX += 105, currY, 55, 20, (Component)Component.m_237113_((String)String.valueOf(this.weight)));
        weight.m_257771_((Component)Component.m_237113_((String)"Weight"));
        EditBox minCount = new EditBox(this.f_96547_, currX += 60, currY, 55, 20, (Component)Component.m_237113_((String)String.valueOf(this.minCount)));
        minCount.m_257771_((Component)Component.m_237113_((String)"Min Count"));
        EditBox maxCount = new EditBox(this.f_96547_, currX += 60, currY, 55, 20, (Component)Component.m_237113_((String)String.valueOf(this.maxCount)));
        maxCount.m_257771_((Component)Component.m_237113_((String)"Max Count"));
        resourceName.m_94151_(s -> {
            this.resourceName = s;
        });
        entityType.m_94151_(s -> {
            this.entityType = s;
        });
        weight.m_94151_(s -> {
            try {
                this.weight = Integer.parseInt(s);
            }
            catch (NumberFormatException ignored) {
                this.weight = 0;
            }
        });
        minCount.m_94151_(s -> {
            try {
                this.minCount = Integer.parseInt(s);
            }
            catch (NumberFormatException ignored) {
                this.minCount = 0;
            }
        });
        maxCount.m_94151_(s -> {
            try {
                this.maxCount = Integer.parseInt(s);
            }
            catch (NumberFormatException ignored) {
                this.maxCount = 0;
            }
        });
        this.m_142416_((GuiEventListener)resourceName);
        this.m_142416_((GuiEventListener)entityType);
        this.m_142416_((GuiEventListener)weight);
        this.m_142416_((GuiEventListener)minCount);
        this.m_142416_((GuiEventListener)maxCount);
        Button addButton = Button.m_253074_((Component)Component.m_237113_((String)"Add"), b -> this.addNew()).m_252794_(this.f_96543_ / 2 - 25, currY + 25).m_253046_(50, 20).m_253136_();
        this.m_142416_((GuiEventListener)addButton);
        this.tempWidgets = List.of(resourceName, entityType, weight, minCount, maxCount, addButton);
    }

    public void loadWidgets() {
        int currY = 40;
        for (SpawnableHolder holder : this.data) {
            int currX = this.f_96543_ / 2 - 200;
            EditBox resourceName = new EditBox(this.f_96547_, currX, currY, 100, 20, (Component)Component.m_237113_((String)holder.resourceName().toString()));
            resourceName.m_94144_(holder.resourceName().toString());
            EditBox entityType = new EditBox(this.f_96547_, currX += 105, currY, 100, 20, (Component)Component.m_237113_((String)holder.data().f_48404_.toString()));
            entityType.m_94144_(EntityType.m_20613_((EntityType)holder.data().f_48404_).toString());
            EditBox weight = new EditBox(this.f_96547_, currX += 105, currY, 55, 20, (Component)Component.m_237113_((String)String.valueOf(holder.data().m_142631_().m_146281_())));
            weight.m_94144_(holder.data().m_142631_().toString());
            EditBox minCount = new EditBox(this.f_96547_, currX += 60, currY, 55, 20, (Component)Component.m_237113_((String)String.valueOf(holder.data().f_48405_)));
            minCount.m_94144_(String.valueOf(holder.data().f_48405_));
            EditBox maxCount = new EditBox(this.f_96547_, currX += 60, currY, 50, 20, (Component)Component.m_237113_((String)String.valueOf(holder.data().f_48406_)));
            maxCount.m_94144_(String.valueOf(holder.data().f_48406_));
            resourceName.m_94151_(s -> this.sendNbt(tag -> {
                tag.m_128405_("id", ((Integer)holder.id().get()).intValue());
                tag.m_128359_("resourceName", s);
            }));
            entityType.m_94151_(s -> this.sendNbt(tag -> {
                tag.m_128405_("id", ((Integer)holder.id().get()).intValue());
                tag.m_128359_("entityType", s);
            }));
            weight.m_94151_(s -> {
                try {
                    int w = Integer.parseInt(s);
                    this.sendNbt(tag -> {
                        tag.m_128405_("id", ((Integer)holder.id().get()).intValue());
                        tag.m_128405_("weight", w);
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            minCount.m_94151_(s -> {
                try {
                    int m = Integer.parseInt(s);
                    this.sendNbt(tag -> {
                        tag.m_128405_("id", ((Integer)holder.id().get()).intValue());
                        tag.m_128405_("minCount", m);
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            maxCount.m_94151_(s -> {
                try {
                    int m = Integer.parseInt(s);
                    this.sendNbt(tag -> {
                        tag.m_128405_("id", ((Integer)holder.id().get()).intValue());
                        tag.m_128405_("maxCount", m);
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            Button remove = Button.m_253074_((Component)Component.m_237113_((String)"X"), b -> {
                this.sendNbt(tag -> {
                    tag.m_128405_("remove", ((Integer)holder.id().get()).intValue());
                    this.widgets.get(holder).forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
                    this.widgets.remove(holder);
                });
                b.f_93623_ = false;
                b.f_93624_ = false;
            }).m_252794_(currX + 60, currY).m_253046_(20, 20).m_253136_();
            this.widgets.put(holder, List.of(resourceName, entityType, weight, minCount, maxCount, remove));
            currY += 30;
            this.m_142416_((GuiEventListener)resourceName);
            this.m_142416_((GuiEventListener)entityType);
            this.m_142416_((GuiEventListener)weight);
            this.m_142416_((GuiEventListener)minCount);
            this.m_142416_((GuiEventListener)maxCount);
            this.m_142416_((GuiEventListener)remove);
        }
    }

    public void handle(ScreenScheme.ScreenMessage screenMessage) {
        this.m_169413_();
        this.widgets.clear();
        this.data = Manager.load(screenMessage.tag());
        this.loadWidgets();
        this.header();
    }
}

