/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.spawnable.screen;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.refractionapi.refraction.feature.scheme.ScreenScheme;
import net.refractionapi.refraction.feature.scheme.ServerScheme;
import net.zeus.spawnable.init.Manager;
import net.zeus.spawnable.init.SpawnableHolder;
import net.zeus.spawnable.init.SpawnableScreenRegistry;

public class EditValuesServer
extends ServerScheme {
    public <T> EditValuesServer(ServerPlayer player) {
        super(SpawnableScreenRegistry.EDIT, player);
    }

    public void modify(CompoundTag tag) {
        int id = tag.m_128451_("id");
        SpawnableHolder holder = Manager.getHolder(id);
        if (holder == null) {
            return;
        }
        if (tag.m_128441_("resourceName")) {
            holder.setResourceName(tag.m_128461_("resourceName"));
        }
        if (tag.m_128441_("entityType")) {
            String entityTypeName = tag.m_128461_("entityType");
            holder.setEntityType(entityTypeName);
        }
        if (tag.m_128441_("weight")) {
            holder.setWeight(tag.m_128451_("weight"));
        }
        if (tag.m_128441_("minCount")) {
            holder.setMinCount(tag.m_128451_("minCount"));
        }
        if (tag.m_128441_("maxCount")) {
            holder.setMaxCount(tag.m_128451_("maxCount"));
        }
    }

    public void add(CompoundTag tag) {
        SpawnableHolder holder = SpawnableHolder.fromTag(tag);
        if (holder == null) {
            return;
        }
        Manager.addHolder(holder);
        this.sendNbt(Manager.compileData());
    }

    public void remove(int id) {
        Manager.removeHolder(id);
        this.sendNbt(Manager.compileData());
    }

    public void handleMessage(ScreenScheme.ScreenMessage screenMessage) {
        CompoundTag tag = screenMessage.tag();
        if (tag.m_128441_("new")) {
            this.add(tag);
        } else if (tag.m_128441_("id")) {
            this.modify(tag);
        } else if (tag.m_128441_("remove")) {
            this.remove(tag.m_128451_("remove"));
        }
    }
}

