/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class TestedCodec<T>
implements Codec<T> {
    public static final TestResult SUCCESS = new TestResult(true, () -> null);
    public static final TestResult FAIL = new TestResult(false, () -> "Test not passed");
    private final Codec<T> codec;
    private final EncodeTest<T> encodeTest;
    private final DecodeTest<?> decodeTest;

    public static TestResult success() {
        return SUCCESS;
    }

    public static TestResult fail(Supplier<String> msg) {
        return new TestResult(false, msg);
    }

    public static TestResult fail() {
        return FAIL;
    }

    public TestedCodec(Codec<T> codec, EncodeTest<T> encodeTest, DecodeTest<?> decodeTest) {
        this.codec = codec;
        this.encodeTest = encodeTest;
        this.decodeTest = decodeTest;
    }

    public Codec<T> getCodec() {
        return this.codec;
    }

    public TestResult canEncode(T object) {
        return this.encodeTest.test(object);
    }

    public <I> TestResult canDecode(DynamicOps<I> ops, I input) {
        DecodeTest tester = this.decodeTest.adapt();
        return tester.test(ops, input);
    }

    public <I> DataResult<Pair<T, I>> decode(DynamicOps<I> ops, I input) {
        TestResult testResult = this.canDecode(ops, input);
        if (testResult.success()) {
            return this.codec.decode(ops, input);
        }
        return DataResult.error(testResult.msg());
    }

    public <O> DataResult<O> encode(T object, DynamicOps<O> ops, O prefix) {
        TestResult testResult = this.canEncode(object);
        if (testResult.success()) {
            return this.codec.encode(object, ops, prefix);
        }
        return DataResult.error(testResult.msg());
    }

    public <T2> TestedCodec<T2> adapt() {
        return this;
    }

    public record TestResult(boolean success, @NotNull Supplier<String> msg) {
    }

    public static interface EncodeTest<T> {
        public TestResult test(T var1);

        default public <I2> EncodeTest<I2> adapt() {
            return this;
        }
    }

    public static interface DecodeTest<I> {
        public TestResult test(DynamicOps<I> var1, I var2);

        default public <I2> DecodeTest<I2> adapt() {
            return this;
        }
    }
}

