/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.block.entity;

import cool.muyucloud.croparia.access.CropBlockAccess;
import cool.muyucloud.croparia.api.repo.ContainerRepo;
import cool.muyucloud.croparia.api.repo.RepoProxy;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import cool.muyucloud.croparia.registry.BlockEntities;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1716;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GreenhouseBlockEntity
extends class_2586
implements class_3908,
class_1263 {
    private final class_2371<class_1799> inventory;
    private final RepoProxy<ItemSpec> proxy = RepoProxy.item(new ContainerRepo(this));

    public GreenhouseBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BlockEntities.GREENHOUSE_BE.get(), pos, state);
        this.inventory = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    }

    public static void tick(class_1937 level, class_2338 worldPosition, GreenhouseBlockEntity gbe) {
        class_2680 belowState;
        class_2248 class_22482;
        if (!level.field_9236 && (class_22482 = (belowState = level.method_8320(worldPosition.method_10074())).method_26204()) instanceof class_2302) {
            class_2302 block = (class_2302)class_22482;
            class_1792 seed = block.method_8389();
            if (block.method_9825(belowState)) {
                List droppedStacks = class_2248.method_9562((class_2680)belowState, (class_3218)Objects.requireNonNull(level.method_8503()).method_3847(level.method_27983()), (class_2338)worldPosition.method_10074(), (class_2586)level.method_8321(worldPosition.method_10074()));
                boolean decreased = false;
                for (class_1799 stack : droppedStacks) {
                    long sim;
                    if (!decreased && stack.method_31574(seed)) {
                        stack.method_7934(1);
                        decreased = true;
                    }
                    if ((sim = gbe.proxy.simAccept(ItemSpec.of(stack), stack.method_7947())) >= (long)stack.method_7947()) continue;
                    return;
                }
                for (class_1799 stack : droppedStacks) {
                    if (!stack.method_7960()) {
                        gbe.method_5431();
                    }
                    gbe.proxy.accept(ItemSpec.of(stack), stack.method_7947());
                }
                class_2758 property = ((CropBlockAccess)block).cif$getAgeProperty();
                int maxAge = block.method_9827();
                level.method_8501(worldPosition.method_10074(), (class_2680)block.method_9564().method_11657((class_2769)property, (Comparable)Integer.valueOf(maxAge / 2)));
            }
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 provider) {
        super.method_11014(nbt, provider);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)provider);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 provider) {
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)provider);
        super.method_11007(nbt, provider);
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        return this.inventory.stream().allMatch(class_1799::method_7960);
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    @NotNull
    public class_1799 method_5434(int slot, int amount) {
        class_1799 removed = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        if (!removed.method_7960()) {
            this.method_5431();
        }
        return removed;
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        class_1799 stored = this.method_5438(slot);
        if (class_1799.method_31577((class_1799)stored, (class_1799)stack) && stored.method_7947() == stack.method_7947()) {
            return;
        }
        this.method_5431();
        this.inventory.set(slot, (Object)stack);
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        if (this.inventory.isEmpty()) {
            return;
        }
        this.method_5431();
        this.inventory.clear();
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_30163((String)"Greenhouse");
    }

    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new class_1716(syncId, inv, (class_1263)this);
    }

    @Nullable
    public RepoProxy<ItemSpec> visitItem() {
        return this.proxy;
    }
}

