/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.config.Config;
import cool.muyucloud.croparia.config.ConfigFileHandler;
import cool.muyucloud.croparia.util.text.Texts;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class ConfigCommand {
    private static final LiteralArgumentBuilder<class_2168> FILE_PATH = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"filePath").executes(context -> {
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.filePath", Config.resolvePath(CropariaIf.CONFIG.getFilePath())), true);
        return 1;
    })).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
        String path = StringArgumentType.getString((CommandContext)context, (String)"value");
        CropariaIf.CONFIG.setFilePath(Config.parsePath(path).orElseThrow());
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.filePath", path), true);
        return 1;
    }));
    private static final LiteralArgumentBuilder<class_2168> RECIPE_WIZARD = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"recipeWizard").executes(context -> {
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.recipeWizard", Config.resolvePath(CropariaIf.CONFIG.getRecipeWizard()), true));
        return 1;
    })).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
        String path = StringArgumentType.getString((CommandContext)context, (String)"value");
        CropariaIf.CONFIG.setRecipeWizard(Config.parsePath(path).orElseThrow());
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.recipeWizard", path), true);
        return 1;
    }));
    private static final LiteralArgumentBuilder<class_2168> INFUSOR = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"infusor").executes(context -> {
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.infusor", CropariaIf.CONFIG.getInfusor().toString()), true);
        return 1;
    })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
        CropariaIf.CONFIG.setInfusor(BoolArgumentType.getBool((CommandContext)context, (String)"value"));
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.infusor", CropariaIf.CONFIG.getInfusor().toString()), true);
        return 1;
    }));
    private static final LiteralArgumentBuilder<class_2168> RITUAL = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ritual").executes(context -> {
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.ritual", CropariaIf.CONFIG.getRitual().toString()), true);
        return 1;
    })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
        CropariaIf.CONFIG.setRitual(BoolArgumentType.getBool((CommandContext)context, (String)"value"));
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.ritual", CropariaIf.CONFIG.getRitual().toString()), true);
        return 1;
    }));
    private static final LiteralArgumentBuilder<class_2168> FRUIT_USE = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fruitUse").executes(context -> {
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.fruitUse", CropariaIf.CONFIG.getFruitUse().toString()), true);
        return 1;
    })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
        CropariaIf.CONFIG.setFruitUse(BoolArgumentType.getBool((CommandContext)context, (String)"value"));
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.fruitUse", CropariaIf.CONFIG.getFruitUse().toString()), true);
        return 1;
    }));
    private static final LiteralArgumentBuilder<class_2168> SOAK_ATTEMPTS = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"soakAttempts").executes(context -> {
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.soakAttempts", CropariaIf.CONFIG.getSoakAttempts().toString()), true);
        return 1;
    })).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).suggests((context, builder) -> {
        builder.suggest(2);
        builder.suggest(0);
        return builder.buildFuture();
    }).executes(context -> {
        CropariaIf.CONFIG.setSoakAttempts(IntegerArgumentType.getInteger((CommandContext)context, (String)"value"));
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.soakAttempts", CropariaIf.CONFIG.getSoakAttempts().toString()), true);
        return 1;
    }));
    private static final LiteralArgumentBuilder<class_2168> AUTO_RELOAD = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"autoReload").executes(context -> {
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.autoReload", CropariaIf.CONFIG.getAutoReload().toString()), true);
        return 1;
    })).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).suggests((context, builder) -> {
        builder.suggest("-1");
        builder.suggest("20");
        return builder.buildFuture();
    }).executes(context -> {
        CropariaIf.CONFIG.setAutoReload(IntegerArgumentType.getInteger((CommandContext)context, (String)"value"));
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.autoReload", CropariaIf.CONFIG.getAutoReload().toString()), true);
        return 1;
    }));
    private static final LiteralArgumentBuilder<class_2168> OVERRIDE = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"override").executes(context -> {
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.override", CropariaIf.CONFIG.getOverride().toString()), true);
        return 1;
    })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
        CropariaIf.CONFIG.setOverride(BoolArgumentType.getBool((CommandContext)context, (String)"value"));
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.override", CropariaIf.CONFIG.getOverride().toString()), true);
        return 1;
    }));
    private static final LiteralArgumentBuilder<class_2168> RESET = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").executes(context -> {
        Texts.chat((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.reset.warn", new Object[0]).method_10852((class_2561)Texts.translatable("commands.croparia.config.reset.confirm", new Object[0]).method_27696(Texts.runCommand("cropariaServer reset confirm")).method_27696(Texts.inlineMouseBehavior())));
        return 1;
    })).then(class_2170.method_9247((String)"confirm").executes(context -> {
        ConfigFileHandler.save(new Config());
        ConfigFileHandler.reload(CropariaIf.CONFIG);
        Texts.success((class_2168)context.getSource(), (class_2561)Texts.translatable("commands.croparia.config.reset.success", new Object[0]), true);
        return 1;
    }));

    public static ArgumentBuilder<class_2168, ?> buildFilePath() {
        return FILE_PATH;
    }

    public static ArgumentBuilder<class_2168, ?> buildRecipeWizard() {
        return RECIPE_WIZARD;
    }

    public static ArgumentBuilder<class_2168, ?> buildSoakAttempts() {
        return SOAK_ATTEMPTS;
    }

    public static ArgumentBuilder<class_2168, ?> buildInfusor() {
        return INFUSOR;
    }

    public static ArgumentBuilder<class_2168, ?> buildRitual() {
        return RITUAL;
    }

    public static ArgumentBuilder<class_2168, ?> buildFruitUse() {
        return FRUIT_USE;
    }

    public static ArgumentBuilder<class_2168, ?> buildAutoReload() {
        return AUTO_RELOAD;
    }

    public static ArgumentBuilder<class_2168, ?> buildOverride() {
        return OVERRIDE;
    }

    public static ArgumentBuilder<class_2168, ?> buildReset() {
        return RESET;
    }
}

