/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.crop.CropAccess;
import cool.muyucloud.croparia.api.crop.block.CropariaCropBlock;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.registry.Crops;
import cool.muyucloud.croparia.registry.DgRegistries;
import cool.muyucloud.croparia.util.CifUtil;
import cool.muyucloud.croparia.util.text.FailureMessenger;
import cool.muyucloud.croparia.util.text.SuccessMessenger;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class CropCommand {
    private static final LiteralArgumentBuilder<class_2168> CROP = (LiteralArgumentBuilder)class_2170.method_9247((String)"crop").then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> Crops.cropSuggestions(builder)).executes(context -> {
        class_2960 id = class_2232.method_9443((CommandContext)context, (String)"id");
        return CropCommand.reportSingular(id, Texts.success((class_2168)context.getSource()), Texts.failure((class_2168)context.getSource()));
    }));

    public static LiteralArgumentBuilder<class_2168> build() {
        return CROP;
    }

    public static int reportSingular(class_2960 id, SuccessMessenger success, FailureMessenger failure) {
        Optional<Crop> crop = DgRegistries.CROPS.forName(id);
        if (crop.isEmpty()) {
            failure.send((class_2561)Texts.translatable("commands.croparia.crop.absent", id));
            return 0;
        }
        class_5250 report = CropCommand.buildReport(crop.get());
        success.send((class_2561)report, false);
        return crop.get().getTier();
    }

    public static int reportForPlayer(class_1657 player, class_1937 world, SuccessMessenger success, FailureMessenger failure) {
        Crop crop = null;
        class_1792 class_17922 = player.method_59958().method_7909();
        if (class_17922 instanceof CropAccess) {
            CropAccess access = (CropAccess)class_17922;
            crop = (Crop)CropAccess.tryGet(access);
        } else {
            class_17922 = world.method_8320(CifUtil.lookingAt(player)).method_26204();
            if (class_17922 instanceof CropAccess) {
                CropAccess access = (CropAccess)class_17922;
                crop = (Crop)CropAccess.tryGet(access);
            }
        }
        if (crop == null) {
            failure.send((class_2561)Texts.translatable("commands.croparia.crop.no_crop", new Object[0]));
            return 0;
        }
        class_5250 report = CropCommand.buildReport(crop);
        success.send((class_2561)report, false);
        return crop.getTier();
    }

    public static class_5250 buildReport(@NotNull Crop crop) {
        class_5250 name = Texts.translatable("commands.croparia.crop.id", crop.getKey().toString());
        class_5250 translation = Texts.translatable("commands.croparia.crop.translationKey", Texts.forStyles(Texts.translatable(crop.getTranslationKey(), new Object[0]), Texts.hoverText(crop.getTranslationKey()), Texts.copyText(crop.getTranslationKey())));
        class_5250 material = Texts.translatable("commands.croparia.crop.material", Texts.literal(crop.getMaterialName(), Texts.suggestCommand("give @s", Objects.requireNonNull(crop.getResult().method_7909().arch$registryName()).toString()), Texts.hoverItem(crop.getMaterialStack()), Texts.inlineMouseBehavior()));
        class_5250 tier = Texts.forStyles(Texts.translatable("commands.croparia.crop.tier", Texts.literal("" + crop.getTier(), Texts.suggestCommand("give @s", CropariaItems.getCroparia(crop.getTier()).getId().toString()), Texts.hoverItem((class_1792)CropariaItems.getCroparia(crop.getTier()).get()), Texts.inlineMouseBehavior())), new class_2583[0]);
        class_5250 color = Texts.translatable("commands.croparia.crop.color", Texts.literal(crop.getColorForm(), Texts.copyText(crop.getColorForm())).method_54663(crop.getColor().getValue()));
        class_5250 type = Texts.translatable("commands.croparia.crop.type", Texts.literal(crop.getType(), Texts.copyText(crop.getType())));
        class_5250 seed = Texts.translatable("commands.croparia.crop.seed", Texts.literal(crop.getSeedId().toString(), Texts.suggestCommand("give @s", crop.getSeedId().toString()), Texts.hoverItem(crop.getSeedId()), Texts.inlineMouseBehavior()));
        class_5250 fruit = Texts.translatable("commands.croparia.crop.fruit", Texts.literal(crop.getFruitId().toString(), Texts.suggestCommand("give @s", crop.getFruitId().toString()), Texts.hoverItem(crop.getFruitId()), Texts.inlineMouseBehavior()));
        class_5250 cropBlock = Texts.translatable("commands.croparia.crop.cropBlock", Texts.literal(crop.getBlockId().toString(), Texts.suggestCommand("setblock ~ ~ ~", String.valueOf(crop.getBlockId()) + "[age=7]"), Texts.hoverText((class_2561)crop.getCropBlock().map(CropariaCropBlock::method_9518).orElse(Texts.literal("error", new class_2583[0]))), Texts.inlineMouseBehavior()));
        class_5250 status = CropCommand.diagnose(crop);
        return name.method_27693("\n").method_10852((class_2561)translation).method_27693("\n").method_10852((class_2561)material).method_27693("\n").method_10852((class_2561)tier).method_27693("\n").method_10852((class_2561)color).method_27693("\n").method_10852((class_2561)type).method_27693("\n").method_10852((class_2561)seed).method_27693("\n").method_10852((class_2561)fruit).method_27693("\n").method_10852((class_2561)cropBlock).method_27693("\n").method_10852((class_2561)status);
    }

    public static class_5250 diagnose(@NotNull Crop crop) {
        if (crop.getResult().method_7960()) {
            return Texts.translatable("commands.croparia.crop.status.material", new Object[0]).method_27692(class_124.field_1061);
        }
        if (!crop.shouldLoad()) {
            return Texts.translatable("commands.croparia.crop.status.unavailable", new Object[0]).method_27692(class_124.field_1054);
        }
        return Texts.translatable("commands.croparia.crop.status.good", new Object[0]).method_27692(class_124.field_1060);
    }
}

