/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.component;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import cool.muyucloud.croparia.access.StateHolderAccess;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockProperties
implements class_9299,
Iterable<Map.Entry<String, String>> {
    public static final Codec<BlockProperties> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).xmap(BlockProperties::new, BlockProperties::getProperties);
    public static final class_9139<class_2540, BlockProperties> STREAM_CODEC = class_9139.method_56437((buf, component) -> buf.method_49395((Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING), component.getProperties()), buf -> new BlockProperties((Map)buf.method_49394((Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING))));
    public static final class_9331<BlockProperties> TYPE;
    public static final BlockProperties EMPTY;
    public static final class_2561 TITLE;
    private final Map<String, String> properties;

    public static BlockProperties extract(@NotNull class_2680 state) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map<String, String> defaults = ((StateHolderAccess)state.method_26204().method_9564()).cif$getProperties();
        StateHolderAccess access = (StateHolderAccess)state;
        for (Map.Entry<String, String> entry : access.cif$getProperties().entrySet()) {
            if (entry.getValue().equals(defaults.get(entry.getKey()))) continue;
            builder.put(entry);
        }
        return BlockProperties.of((Map<String, String>)builder.build());
    }

    public static BlockProperties of(@NotNull class_2680 state) {
        return BlockProperties.of(((StateHolderAccess)state).cif$getProperties());
    }

    @NotNull
    public static BlockProperties of(@NotNull Map<String, String> properties) {
        return properties.isEmpty() ? EMPTY : new BlockProperties(properties);
    }

    protected BlockProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @NotNull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isEmpty() {
        return this.getProperties().isEmpty();
    }

    public void method_57409(class_1792.class_9635 tooltipContext, Consumer<class_2561> consumer, class_1836 tooltipFlag) {
        if (this.getProperties().isEmpty()) {
            return;
        }
        consumer.accept(TITLE);
        this.getProperties().forEach((? super K key, ? super V value) -> consumer.accept((class_2561)Texts.literal("%s=%s".formatted(key, value), new class_2583[0])));
    }

    public boolean isSubsetOf(class_2680 state) {
        StateHolderAccess access = (StateHolderAccess)state;
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            @NotNull String key = entry.getKey();
            @Nullable String value = entry.getValue();
            @Nullable String blockVal = access.cif$getValue(key);
            if (value == null && blockVal != null || Objects.equals(blockVal, value)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockProperties)) {
            return false;
        }
        BlockProperties that = (BlockProperties)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hashCode(this.properties);
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.getProperties().entrySet().iterator();
    }

    static {
        EMPTY = new BlockProperties(Map.of());
        class_9331.class_9332 builder = class_9331.method_57873();
        builder.method_57881(CODEC).method_57882(STREAM_CODEC);
        TYPE = builder.method_57880();
        TITLE = Texts.translatable("tooltip.croparia.block_properties", new Object[0]);
    }
}

