/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.crop;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.Codec;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.crop.AbstractCrop;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.generator.util.DgRegistry;
import cool.muyucloud.croparia.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class CropRegistry<C extends AbstractCrop>
implements DgRegistry<C> {
    public static final CropRegistry<Crop> CROPS = new CropRegistry(CropariaIf.CONFIG.getFilePath().resolve("crops"), Crop.CODEC.codec());
    private static final Gson GSON = new Gson();
    private final Path path;
    private final Codec<C> codec;
    private final Map<class_2960, C> all = new HashMap<class_2960, C>();
    private final Map<class_2960, C> loaded = new HashMap<class_2960, C>();

    public CropRegistry(Path path, Codec<C> codec) {
        this.path = path;
        this.codec = codec;
    }

    public Path getPath() {
        return this.path;
    }

    public Codec<C> getCodec() {
        return this.codec;
    }

    public void forLoaded(Consumer<C> consumer) {
        this.loaded.values().forEach(consumer);
    }

    public void register(C crop) {
        this.all.put(crop.getKey(), crop);
        if (crop.shouldLoad()) {
            if (!this.loaded.containsKey(crop.getKey())) {
                ((AbstractCrop)crop).onRegister();
            }
            this.loaded.put(crop.getKey(), crop);
        } else {
            this.loaded.remove(crop.getKey());
        }
    }

    public void readCrops() {
        File file = this.getPath().toFile();
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IllegalStateException("Failed to establish directory \"%s\"".formatted(file));
        }
        this.readCrops(this.getPath());
    }

    protected void readCrops(Path parent) {
        try (Stream<Path> paths = Files.list(parent);){
            paths.forEach(path -> {
                File file = path.toFile();
                if (file.isFile()) {
                    this.readCrop(file);
                } else {
                    this.readCrops((Path)path);
                }
            });
        }
        catch (IOException e) {
            CropariaIf.LOGGER.error("Failed to read crops", (Throwable)e);
        }
    }

    protected void readCrop(File file) {
        if (!file.getName().endsWith(".json")) {
            return;
        }
        try {
            CodecUtil.readJson(file, this.getCodec()).ifSuccess(this::register);
        }
        catch (IOException e) {
            CropariaIf.LOGGER.error("Failed to read crop from file \"%s\"".formatted(file), (Throwable)e);
        }
    }

    public void dumpCrops() {
        this.all.values().forEach(this::dumpCrop);
    }

    public Path dumpCrop(@NotNull C crop) {
        Path cropPath = this.getPath().resolve(crop.getKey().toString().replace(":", "/") + ".json");
        StringWriter result = new StringWriter();
        CodecUtil.encodeJson(crop, this.getCodec()).mapOrElse(json -> {
            try (JsonWriter writer = new JsonWriter((Writer)result);){
                writer.setIndent("  ");
                GSON.toJson(json, writer);
                FileUtil.write(cropPath.toFile(), result.toString(), true);
            }
            catch (IOException e) {
                CropariaIf.LOGGER.error("Failed to dump crop \"%s\"".formatted(crop.getKey()), (Throwable)e);
            }
            return null;
        }, e -> {
            CropariaIf.LOGGER.error("Failed to dump crop \"%s\": %s".formatted(crop.getKey(), e.message()));
            return null;
        });
        return cropPath;
    }

    public boolean exists(class_2960 name) {
        return this.all.containsKey(name);
    }

    @Override
    @NotNull
    public Iterator<C> iterator() {
        return this.all.values().iterator();
    }

    @Override
    public Optional<C> forName(class_2960 id) {
        return Optional.ofNullable((AbstractCrop)this.all.get(id));
    }

    public int size() {
        return this.all.size();
    }
}

