/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.element;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.crop.util.Color;
import cool.muyucloud.croparia.api.element.block.ElementalLiquidBlock;
import cool.muyucloud.croparia.api.element.fluid.ElementalFlowing;
import cool.muyucloud.croparia.api.element.fluid.ElementalSource;
import cool.muyucloud.croparia.api.element.item.ElementalBucket;
import cool.muyucloud.croparia.api.element.item.ElementalGem;
import cool.muyucloud.croparia.api.element.item.ElementalPotion;
import cool.muyucloud.croparia.api.generator.util.DgEntry;
import cool.muyucloud.croparia.api.placeholder.PatternKey;
import cool.muyucloud.croparia.api.placeholder.Placeholder;
import cool.muyucloud.croparia.api.placeholder.TypeMapper;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.registry.CropariaFluids;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.registry.Tabs;
import cool.muyucloud.croparia.util.CifUtil;
import dev.architectury.core.fluid.ArchitecturyFluidAttributes;
import dev.architectury.core.fluid.SimpleArchitecturyFluidAttributes;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public enum Element implements DgEntry,
class_3542,
Comparable<Element>
{
    EMPTY,
    AIR("air", Color.of(6453378), attr -> {}),
    EARTH("earth", Color.of(11884313), attr -> {}),
    ELEMENTAL("elemental", Color.of(6238065), attr -> {}),
    FIRE("fire", Color.of(11010055), attr -> {}),
    WATER("water", Color.of(750238), attr -> {});

    public static final Placeholder<Element> PLACEHOLDER;
    private final class_2960 id;
    private final Color color;
    private final String translationKey;
    private final RegistrySupplier<ElementalSource> fluidSource;
    private final RegistrySupplier<ElementalFlowing> fluidFlowing;
    private final RegistrySupplier<ElementalLiquidBlock> fluidBlock;
    private final RegistrySupplier<ElementalBucket> bucket;
    private final RegistrySupplier<ElementalPotion> potion;
    private final RegistrySupplier<ElementalGem> gem;

    public static Element parse(String name) {
        return Element.valueOf(name.toUpperCase());
    }

    private Element() {
        this.id = CropariaIf.of("empty");
        this.color = new Color(-1);
        this.translationKey = "element.croparia.empty";
        this.fluidSource = null;
        this.fluidFlowing = null;
        this.fluidBlock = null;
        this.bucket = null;
        this.potion = null;
        this.gem = null;
    }

    private Element(String name, Color color, Consumer<SimpleArchitecturyFluidAttributes> appendix) {
        if (!name.matches("[A-Za-z0-9_]+")) {
            throw new IllegalArgumentException("Element name must only contain lowercase letters, numbers, underscores");
        }
        this.id = CropariaIf.of(name);
        this.color = color;
        this.translationKey = "element.croparia." + name;
        SimpleArchitecturyFluidAttributes attr = SimpleArchitecturyFluidAttributes.of(() -> (class_3611)this.getFluidFlowing().get(), () -> (class_3611)this.getFluidSource().get()).block(() -> Optional.ofNullable((ElementalLiquidBlock)this.getFluidBlock().get())).bucketItem(() -> Optional.ofNullable((class_1792)this.getBucket().get())).sourceTexture(this.parseId("block/%s_still")).flowingTexture(this.parseId("block/%s_flow"));
        appendix.accept(attr);
        this.fluidSource = CropariaFluids.registerFluid(this.parseId("fluid_%s"), () -> new ElementalSource(this, (ArchitecturyFluidAttributes)attr));
        this.fluidFlowing = CropariaFluids.registerFluid(this.parseId("fluid_%s_flow"), () -> new ElementalFlowing(this, (ArchitecturyFluidAttributes)attr));
        this.fluidBlock = CropariaBlocks.registerBlock(this.parseId("fluid_%s"), properties -> new ElementalLiquidBlock(this, class_4970.class_2251.method_9637().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)this.parseId("fluid_%s"))).method_9631(state -> 8).method_9634().method_9632(100.0f).method_42327()));
        this.bucket = CropariaItems.registerItem(this.parseId("bucket_%s"), properties -> new ElementalBucket(this, (Supplier<? extends class_3611>)this.getFluidSource(), properties.method_7889(1).arch$tab(Tabs.MAIN).method_7896(class_1802.field_8469)));
        this.potion = CropariaItems.registerItem(this.parseId("potion_%s"), properties -> new ElementalPotion(this, properties.arch$tab(Tabs.MAIN).method_7896(class_1802.field_8469)));
        this.gem = CropariaItems.registerItem(this.parseId("gem_%s"), properties -> new ElementalGem(this, properties.arch$tab(Tabs.MAIN)));
    }

    public class_2960 parseId(String pattern) {
        return CifUtil.formatId(pattern, this.getKey());
    }

    public Color getColor() {
        return this.color;
    }

    public RegistrySupplier<ElementalFlowing> getFluidFlowing() {
        return this.fluidFlowing;
    }

    public RegistrySupplier<ElementalSource> getFluidSource() {
        return this.fluidSource;
    }

    public RegistrySupplier<ElementalLiquidBlock> getFluidBlock() {
        return this.fluidBlock;
    }

    public RegistrySupplier<ElementalBucket> getBucket() {
        return this.bucket;
    }

    public RegistrySupplier<ElementalPotion> getPotion() {
        return this.potion;
    }

    public RegistrySupplier<ElementalGem> getGem() {
        return this.gem;
    }

    @NotNull
    public String method_15434() {
        return this.getKey().method_12832();
    }

    @Override
    @NotNull
    public class_2960 getKey() {
        return this.id;
    }

    public Placeholder<Element> placeholder() {
        return PLACEHOLDER;
    }

    @Override
    public boolean shouldLoad() {
        return this != EMPTY;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    static {
        PLACEHOLDER = Placeholder.build(builder -> builder.then(PatternKey.literal("name"), TypeMapper.of(Element::method_15434), Placeholder.STRING).then(PatternKey.literal("color"), TypeMapper.of(Element::getColor), Color.PLACEHOLDER).then(PatternKey.literal("fluid_source"), TypeMapper.of(element -> element.getFluidSource().getId()), Placeholder.ID).then(PatternKey.literal("fluid_flowing"), TypeMapper.of(element -> element.getFluidFlowing().getId()), Placeholder.ID).then(PatternKey.literal("liquid_block"), TypeMapper.of(element -> element.getFluidBlock().getId()), Placeholder.ID).then(PatternKey.literal("bucket"), TypeMapper.of(element -> element.getBucket().getId()), Placeholder.ID).then(PatternKey.literal("potion"), TypeMapper.of(element -> element.getPotion().getId()), Placeholder.ID).then(PatternKey.literal("gem"), TypeMapper.of(element -> element.getGem().getId()), Placeholder.ID).overwrite(DgEntry.PLACEHOLDER, TypeMapper.of(element -> element)));
    }
}

