/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.placeholder;

import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public record PatternKey(Pattern pattern) {
    public static final Pattern PLACEHOLDER = Pattern.compile("^\\$\\{(?s)(.+)}$");
    public static final Pattern EMPTY = Pattern.compile("^$");
    public static final Pattern QUOTE_IF_STR = PatternKey.literal("_qis");
    public static final Pattern QUOTE = PatternKey.literal("_q");
    public static final Pattern MAP_MAP_KEY = Pattern.compile("^mapKey\\(([^)]*)\\)$");
    public static final Pattern MAP_MAP_VALUE = Pattern.compile("^mapValue\\(([^)]*)\\)$");
    public static final Pattern MAP_GET = Pattern.compile("^get\\(([^)]*)\\)$");
    public static final Pattern MAP_GET_OR = Pattern.compile("^getOr\\(([^,]*),([^)]*)\\)$");
    public static final Pattern LIST_MAP = Pattern.compile("map\\(([^)]*)\\)");
    public static final Pattern LIST_MAP_I = Pattern.compile("mapi\\(([^)]*)\\)");
    public static final Pattern LIST_GET = Pattern.compile("^get\\((\\d+)\\)$");
    public static final Pattern LIST_GET_OR = Pattern.compile("^getOr\\((\\d+),([^)]*)\\)$");

    public static PatternKey of(Pattern pattern) {
        return new PatternKey(pattern);
    }

    public static Pattern literal(String literal) {
        if (literal.isEmpty()) {
            return EMPTY;
        }
        return Pattern.compile(Pattern.quote(literal));
    }

    @Override
    @NotNull
    public String toString() {
        return this.pattern.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        Pattern oPattern;
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof Pattern) {
            Pattern oPattern2 = (Pattern)o;
            if (!Objects.equals(this.pattern().pattern(), oPattern2.pattern())) return false;
            if (!Objects.equals(this.pattern().flags(), oPattern2.flags())) return false;
            return true;
        }
        if (!(o instanceof PatternKey)) return false;
        PatternKey patternKey = (PatternKey)o;
        try {
            Pattern pattern;
            oPattern = pattern = patternKey.pattern();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!Objects.equals(this.pattern().pattern(), oPattern.pattern())) return false;
        if (!Objects.equals(this.pattern().flags(), oPattern.flags())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pattern().pattern(), this.pattern().flags());
    }
}

