/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.access.RecipeManagerAccess;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.api.recipe.network.S2CSyncClear;
import cool.muyucloud.croparia.api.recipe.network.S2CSyncRecipe;
import cool.muyucloud.croparia.registry.Recipes;
import cool.muyucloud.croparia.util.Ref;
import cool.muyucloud.croparia.util.SidedRef;
import cool.muyucloud.croparia.util.supplier.Mappable;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_10295;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;

public class TypedSerializer<R extends DisplayableRecipe<?>>
extends class_10355
implements class_3956<R>,
class_1865<R> {
    public static final Codec<TypedSerializer<?>> CODEC = class_2960.field_25139.xmap(Recipes::find, TypedSerializer::getId);
    public static Predicate<class_8786<?>> JEI = holder -> Platform.isModLoaded((String)"jei") && !Platform.isModLoaded((String)"emi");
    public static Predicate<class_8786<?>> NEVER = holder -> false;
    public static Predicate<class_8786<?>> ALWAYS = holder -> true;
    private final class_2960 id;
    private final List<Mappable<class_1799>> stations;
    private final Class<? extends R> recipeClass;
    private final MapCodec<R> codec;
    private final class_9139<class_9129, R> streamCodec;
    private final transient class_10295.class_10296<R> displayType;
    private final transient Predicate<class_8786<?>> syncFilter;
    private final transient Collection<R> synced = new HashSet<R>();

    @SafeVarargs
    public TypedSerializer(class_2960 id, Class<? extends R> recipeClass, MapCodec<R> codec, Predicate<class_8786<?>> syncFilter, Mappable<class_1799> ... stations) {
        this(id, recipeClass, codec, CodecUtil.toStream(codec.codec()), syncFilter, stations);
    }

    @SafeVarargs
    public TypedSerializer(class_2960 id, Class<? extends R> recipeClass, MapCodec<R> codec, class_9139<class_9129, R> streamCodec, Predicate<class_8786<?>> syncFilter, Mappable<class_1799> ... stations) {
        this.id = id;
        this.stations = new ArrayList<Mappable<class_1799>>();
        this.stations.addAll(Arrays.asList(stations));
        this.recipeClass = recipeClass;
        this.codec = codec;
        this.streamCodec = streamCodec;
        this.syncFilter = syncFilter;
        this.displayType = new class_10295.class_10296(codec, streamCodec);
    }

    public <I extends class_9695, T extends DisplayableRecipe<I>> boolean shouldSync(class_8786<T> holder) {
        if (((DisplayableRecipe)holder.comp_1933()).getTypedSerializer() == this) {
            return this.syncFilter.test(holder);
        }
        return false;
    }

    public <I extends class_9695, T extends DisplayableRecipe<I>> TypedSerializer<T> adapt() {
        return this;
    }

    public List<R> find() {
        ArrayList recipes = new ArrayList();
        SidedRef.ifServerOrElse(() -> CropariaIf.ifServer(server -> recipes.addAll(((RecipeManagerAccess)server.method_3772()).cif$byType(this.adapt()).stream().map(holder -> (DisplayableRecipe)holder.comp_1933()).toList())), () -> recipes.addAll(this.getSyncedRecipes()));
        return recipes;
    }

    public <I extends class_9695> Optional<R> find(I input, class_1937 level) {
        Ref result = new Ref();
        SidedRef.ifServerOrElse(() -> CropariaIf.ifServer(server -> result.set(server.method_3772().method_8132(this.adapt(), input, level).map(class_8786::comp_1933).orElse(null))), () -> {
            TypedSerializer adapted = this.adapt();
            for (DisplayableRecipe recipe : adapted.synced) {
                if (!recipe.method_8115(input, level)) continue;
                result.set(recipe);
            }
        });
        return result.optional();
    }

    public void syncRecipes() {
        CropariaIf.ifServer(server -> {
            S2CSyncClear.of(this).send();
            ((RecipeManagerAccess)server.method_3772()).cif$byType(this.adapt()).forEach(holder -> {
                if (this.shouldSync((class_8786)holder)) {
                    SidedRef.ifClient(() -> this.adapt().recordRecipe((DisplayableRecipe)holder.comp_1933()));
                    S2CSyncRecipe.of((DisplayableRecipe)holder.comp_1933()).send();
                }
            });
        });
    }

    public void syncRecipes(@NotNull class_3222 player) {
        CropariaIf.ifServer(server -> {
            S2CSyncClear.of(this).send(player);
            ((RecipeManagerAccess)server.method_3772()).cif$byType(this.adapt()).forEach(holder -> {
                if (this.shouldSync((class_8786)holder)) {
                    SidedRef.ifClient(() -> this.adapt().recordRecipe((DisplayableRecipe)holder.comp_1933()));
                    S2CSyncRecipe.of((DisplayableRecipe)holder.comp_1933()).send(player);
                }
            });
        });
    }

    public Collection<R> getSyncedRecipes() {
        return this.synced;
    }

    public void recordRecipe(R recipe) {
        this.synced.add(recipe);
    }

    public void syncClear() {
        this.synced.clear();
    }

    public List<Mappable<class_1799>> getStations() {
        return this.stations;
    }

    public void addStation(Mappable<class_1799> station) {
        this.stations.add(station);
    }

    public Class<? extends R> getRecipeClass() {
        return this.recipeClass;
    }

    @NotNull
    public MapCodec<R> method_53736() {
        return this.codec;
    }

    @NotNull
    public class_9139<class_9129, R> method_56104() {
        return this.streamCodec;
    }

    @NotNull
    public class_10295.class_10296<R> displayType() {
        return this.displayType;
    }

    public class_2960 getId() {
        return this.id;
    }
}

