/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.repo;

import cool.muyucloud.croparia.api.repo.Repo;
import cool.muyucloud.croparia.api.resource.TypeToken;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import cool.muyucloud.croparia.util.CifUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public record ContainerRepo(@NotNull class_1263 container) implements Repo<ItemSpec>
{
    @Override
    public int size() {
        return this.container().method_5439();
    }

    @Override
    public TypeToken<ItemSpec> getType() {
        return ItemSpec.TYPE;
    }

    @Override
    public boolean isEmpty(int i) {
        return this.container().method_5438(i).method_7960();
    }

    @Override
    public ItemSpec resourceFor(int i) {
        return ItemSpec.of(this.container().method_5438(i));
    }

    @Override
    public long simConsume(int i, ItemSpec resource, long amount) {
        class_1799 stack = this.container().method_5438(i);
        if (!resource.is(stack)) {
            return 0L;
        }
        long stored = stack.method_7947();
        return Math.min(amount, stored);
    }

    @Override
    public long consume(int i, ItemSpec resource, long amount) {
        class_1799 stack = this.container().method_5438(i);
        if (!resource.is(stack)) {
            return 0L;
        }
        int stored = stack.method_7947();
        int consumed = CifUtil.toIntSafe(Math.min(amount, (long)stored));
        stack.method_7934(consumed);
        this.container().method_5447(i, stack);
        return consumed;
    }

    @Override
    public long simAccept(int i, ItemSpec resource, long amount) {
        long capacity = this.capacityFor(i, resource);
        long room = capacity - this.amountFor(i);
        amount = Math.min(amount, room);
        if (!this.container().method_5437(i, resource.createStack(amount))) {
            return 0L;
        }
        class_1799 stored = this.container().method_5438(i);
        if (resource.is(stored) || stored.method_7960()) {
            long accepted = Math.min(this.capacityFor(i, resource) - (long)stored.method_7947(), amount);
            return Math.max(accepted, 0L);
        }
        return 0L;
    }

    @Override
    public long accept(int i, ItemSpec resource, long amount) {
        long capacity = this.capacityFor(i, resource);
        long room = capacity - this.amountFor(i);
        amount = Math.min(amount, room);
        if (!this.container().method_5437(i, resource.createStack(amount))) {
            return 0L;
        }
        class_1799 stored = this.container().method_5438(i);
        if (resource.is(stored) || stored.method_7960()) {
            long accepted = Math.min(this.capacityFor(i, resource) - (long)stored.method_7947(), amount);
            this.container().method_5447(i, resource.createStack(Math.max(accepted, 0L) + (long)stored.method_7947()));
            return accepted;
        }
        return 0L;
    }

    @Override
    public long capacityFor(int i, ItemSpec resource) {
        class_1799 stored = this.container().method_5438(i);
        class_1799 toPlace = resource.createStack();
        int containerSize = this.container().method_58350(toPlace);
        if (stored.method_7960() || resource.is(stored)) {
            return containerSize;
        }
        return 0L;
    }

    @Override
    public long amountFor(int i, ItemSpec resource) {
        class_1799 stored = this.container().method_5438(i);
        if (resource.is(stored)) {
            return stored.method_7947();
        }
        return 0L;
    }

    @Override
    public long amountFor(int i) {
        return this.container().method_5438(i).method_7947();
    }
}

