/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.compat.jei.category;

import cool.muyucloud.croparia.api.core.recipe.RitualStructure;
import cool.muyucloud.croparia.api.recipe.TypedSerializer;
import cool.muyucloud.croparia.compat.jei.category.JeiCategory;
import cool.muyucloud.croparia.compat.jei.drawable.Drawer;
import cool.muyucloud.croparia.compat.jei.drawable.DynamicSlot;
import cool.muyucloud.croparia.compat.jei.drawable.InputManager;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.RangedVec3i;
import cool.muyucloud.croparia.util.Ref;
import cool.muyucloud.croparia.util.Vec2i;
import cool.muyucloud.croparia.util.supplier.SemiSupplier;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_10302;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JeiRitualStructure
extends JeiCategory<RitualStructure> {
    public static final JeiRitualStructure INSTANCE = new JeiRitualStructure();
    public static final Vec2i MAX_DISPLAY_SIZE = new Vec2i(6, 6);

    @Override
    public TypedSerializer<RitualStructure> getTypedSerializer() {
        return RitualStructure.TYPED_SERIALIZER;
    }

    @Override
    public int getWidth() {
        return (MAX_DISPLAY_SIZE.x() + 2) * 18;
    }

    @Override
    public int getHeight() {
        return (MAX_DISPLAY_SIZE.z() + 3) * 18;
    }

    @Override
    @Nullable
    public IDrawable getIcon() {
        return JeiRitualStructure.toDrawable(((class_1747)CropariaItems.RITUAL_STAND.get()).method_7854());
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull RitualStructure recipe, @NotNull IFocusGroup focuses) {
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).add((class_10302)recipe.getRitual());
        for (int x = 0; x < recipe.size().method_10263(); ++x) {
            for (int y = 0; y < recipe.size().method_10264(); ++y) {
                for (int z = 0; z < recipe.size().method_10260(); ++z) {
                    char key = recipe.getPattern().get(x, y, z);
                    if (key == '*') {
                        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).add((class_10302)recipe.getRitual());
                        continue;
                    }
                    if (key == ' ' || key == '.' || key == '$') continue;
                    builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).add((class_10302)recipe.getKeys().get(Character.valueOf(key)));
                }
            }
        }
    }

    public void createRecipeExtras(@NotNull IRecipeExtrasBuilder builder, @NotNull RitualStructure recipe, @NotNull IFocusGroup focuses) {
        class_2382 displaySize = new class_2382(Math.min(recipe.size().method_10263(), MAX_DISPLAY_SIZE.x()), recipe.size().method_10264(), Math.min(recipe.size().method_10260(), MAX_DISPLAY_SIZE.z()));
        if (displaySize.method_10263() == 0 || displaySize.method_10264() == 0 || displaySize.method_10260() == 0) {
            return;
        }
        Ref<RangedVec3i> anchor = new Ref<RangedVec3i>(RangedVec3i.maxBounds(recipe.size().method_10263() - displaySize.method_10263(), recipe.size().method_10264() - 1, recipe.size().method_10260() - displaySize.method_10260()));
        InputManager inputManager = (InputManager)new InputManager().setSize(this.getWidth(), this.getHeight());
        inputManager.onScrolledUp("y-", (manager, mouseX, mouseY, scrollDeltaX, scrollDeltaY) -> anchor.mapAndCompare(RangedVec3i::below)).onScrolledDown("y+", (manager, mouseX, mouseY, scrollDeltaX, scrollDeltaY) -> anchor.mapAndCompare(RangedVec3i::above)).onKeyPressed("z-", 87, (manager, mouseX, mouseY, keyCode, scanCode, modifiers) -> anchor.mapAndCompare(RangedVec3i::north)).onKeyPressed("z+", 83, (manager, mouseX, mouseY, keyCode, scanCode, modifiers) -> anchor.mapAndCompare(RangedVec3i::south)).onKeyPressed("x-", 65, (manager, mouseX, mouseY, keyCode, scanCode, modifiers) -> anchor.mapAndCompare(RangedVec3i::west)).onKeyPressed("x+", 68, (manager, mouseX, mouseY, keyCode, scanCode, modifiers) -> anchor.mapAndCompare(RangedVec3i::east));
        ((InputManager)((InputManager)JeiRitualStructure.add(builder, InputManager.createButton((IDrawable)LEFT_WHITE, (IDrawable)LEFT_DARK)).setSize(12, 12)).setPosition(18, this.getHeight() - 15)).onLeftClicked("y-", (manager, mouseX, mouseY, button) -> anchor.set(((RangedVec3i)((Object)((Object)anchor.get()))).dy(-1)));
        ((InputManager)((InputManager)JeiRitualStructure.add(builder, InputManager.createButton((IDrawable)RIGHT_WHITE, (IDrawable)RIGHT_DARK)).setSize(12, 12)).setPosition(this.getWidth() - 18 - 12, this.getHeight() - 15)).onClicked("y+", (manager, mouseX, mouseY, button) -> anchor.set(((RangedVec3i)((Object)((Object)anchor.get()))).dy(1)));
        ((InputManager)((InputManager)JeiRitualStructure.add(builder, InputManager.createButton((IDrawable)LEFT_WHITE, (IDrawable)LEFT_DARK)).setSize(12, 12)).setPosition(3, displaySize.method_10260() * 18 / 2 + 18 - 6)).onClicked("x-", (manager, mouseX, mouseY, button) -> anchor.set(((RangedVec3i)((Object)((Object)anchor.get()))).dx(-1)));
        ((InputManager)((InputManager)JeiRitualStructure.add(builder, InputManager.createButton((IDrawable)RIGHT_WHITE, (IDrawable)RIGHT_DARK)).setSize(12, 12)).setPosition(displaySize.method_10263() * 18 + 18 + 3, ((displaySize.method_10260() + 2) * 18 - 12) / 2)).onClicked("x+", (manager, mouseX, mouseY, button) -> anchor.set(((RangedVec3i)((Object)((Object)anchor.get()))).dx(1)));
        ((InputManager)((InputManager)JeiRitualStructure.add(builder, InputManager.createButton((IDrawable)UP_WHITE, (IDrawable)UP_DARK)).setSize(12, 12)).setPosition(displaySize.method_10263() * 18 / 2 + 18 - 6, 3)).onClicked("z-", (manager, mouseX, mouseY, button) -> anchor.set(((RangedVec3i)((Object)((Object)anchor.get()))).dz(-1)));
        ((InputManager)((InputManager)JeiRitualStructure.add(builder, InputManager.createButton((IDrawable)DOWN_WHITE, (IDrawable)DOWN_DARK)).setSize(12, 12)).setPosition(displaySize.method_10263() * 18 / 2 + 18 - 6, this.getHeight() - 18 - 15)).onClicked("z+", (manager, mouseX, mouseY, button) -> anchor.set(((RangedVec3i)((Object)((Object)anchor.get()))).dz(1)));
        ArrayList<Drawer> tooltips = new ArrayList<Drawer>();
        for (int x = 0; x < displaySize.method_10263(); ++x) {
            for (int z = 0; z < displaySize.method_10260(); ++z) {
                int finalX = x;
                int finalZ = z;
                SemiSupplier<List> dynamicStacks = SemiSupplier.of(() -> recipe.displaySlot(finalX + ((RangedVec3i)((Object)((Object)anchor.get()))).method_10263(), ((RangedVec3i)((Object)((Object)anchor.get()))).method_10264(), finalZ + ((RangedVec3i)((Object)((Object)anchor.get()))).method_10260()));
                DynamicSlot slot = (DynamicSlot)new DynamicSlot(inst -> {
                    if (recipe.isVirtualRender(finalX + ((RangedVec3i)((Object)((Object)anchor.get()))).method_10263(), ((RangedVec3i)((Object)((Object)anchor.get()))).method_10264(), finalZ + ((RangedVec3i)((Object)((Object)anchor.get()))).method_10260())) {
                        inst.disableClick();
                        inst.disableHighlight();
                    } else {
                        inst.enableClick();
                        inst.enableHighlight();
                    }
                    return (List)dynamicStacks.get();
                }).setPosition(18 * (x + 1), 18 * (z + 1));
                tooltips.add(slot.tooltipDrawer());
                JeiRitualStructure.add(builder, slot);
                anchor.onChanged((old, value) -> {
                    if (!old.equals(value)) {
                        dynamicStacks.refresh();
                    }
                });
            }
        }
        SemiSupplier<class_2561> label = SemiSupplier.of(() -> Texts.translatable("gui.croparia.ritual_structure.label", ((RangedVec3i)((Object)((Object)anchor.get()))).method_10264() + 1));
        anchor.onChanged((old, value) -> {
            if (old.method_10264() != value.method_10264()) {
                label.refresh();
            }
        });
        builder.addDrawable((IDrawable)Drawer.of((guiGraphics, xOffset, yOffset) -> guiGraphics.method_27534(class_310.method_1551().field_1772, (class_2561)label.get(), this.getWidth() / 2, 18 * (displaySize.method_10260() + 2) + 6, class_124.field_1068.method_532().intValue())));
        builder.addDrawable((IDrawable)Drawer.of((guiGraphics, xOffset, yOffset) -> tooltips.forEach(drawer -> drawer.draw(guiGraphics, xOffset, yOffset))));
        JeiRitualStructure.add(builder, inputManager);
    }
}

