/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.codec;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import com.mojang.datafixers.util.Function7;
import com.mojang.datafixers.util.Function8;
import com.mojang.datafixers.util.Function9;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.codec.MultiCodec;
import cool.muyucloud.croparia.api.codec.MultiFieldCodec;
import cool.muyucloud.croparia.api.codec.OptionalMultiFieldCodec;
import cool.muyucloud.croparia.api.codec.TestedCodec;
import cool.muyucloud.croparia.reflection.RecordCodecBuilderReflection;
import cool.muyucloud.croparia.util.FileUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import org.jetbrains.annotations.ApiStatus;

public class CodecUtil {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final PrimitiveCodec<Character> CHAR = new PrimitiveCodec<Character>(){

        public <T> DataResult<Character> read(DynamicOps<T> ops, T input) {
            return ops.getStringValue(input).map(s -> {
                if (s.length() != 1) {
                    throw new IllegalArgumentException("Invalid char: " + s);
                }
                return Character.valueOf(s.charAt(0));
            });
        }

        public <T> T write(DynamicOps<T> ops, Character value) {
            return (T)ops.createString(value.toString());
        }
    };

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiStatus.Experimental
    public static <T> MapCodec<T> toMap(Codec<T> codec) {
        MapCodec mapCodec;
        if (!(codec instanceof MapCodec.MapCodecCodec)) {
            mapCodec = MapCodec.assumeMapUnsafe(codec);
            return mapCodec;
        }
        MapCodec.MapCodecCodec mapCodecCodec = (MapCodec.MapCodecCodec)codec;
        try {
            MapCodec mapCodec2;
            MapCodec map;
            mapCodec = map = (mapCodec2 = mapCodecCodec.codec());
            return mapCodec;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public static <E> MultiCodec<List<E>> listOf(Codec<E> codec) {
        TestedCodec<List> listCodec = CodecUtil.of(Codec.list(codec), (T list) -> list.size() == 1 ? TestedCodec.fail(() -> "Can be applied by singular codec") : TestedCodec.success());
        Codec singularCodec = codec.xmap(Collections::singletonList, List::getFirst);
        return CodecUtil.of(listCodec, singularCodec);
    }

    @SafeVarargs
    public static <T> MultiCodec<T> of(Codec<? extends T> ... codecs) {
        return CodecUtil.of((T toEncode) -> TestedCodec.success(), (DynamicOps<?> ops, ? toDecode) -> TestedCodec.success(), codecs);
    }

    @SafeVarargs
    public static <T> MultiCodec<T> of(TestedCodec.EncodeTest<T> encodeTest, Codec<? extends T> ... codecs) {
        return CodecUtil.of(encodeTest, (DynamicOps<?> ops, ? toDecode) -> TestedCodec.success(), codecs);
    }

    @SafeVarargs
    public static <T> MultiCodec<T> of(TestedCodec.DecodeTest<T> decodeTest, Codec<? extends T> ... codecs) {
        return CodecUtil.of((T toEncode) -> TestedCodec.success(), decodeTest, codecs);
    }

    @SafeVarargs
    public static <T> MultiCodec<T> of(TestedCodec.EncodeTest<T> encodeTest, TestedCodec.DecodeTest<?> decodeTest, Codec<? extends T> ... codecs) {
        MultiCodec result = new MultiCodec();
        for (Codec<? extends T> codec : codecs) {
            if (codec instanceof TestedCodec) {
                TestedCodec testedCodec = (TestedCodec)codec;
                result.add(testedCodec);
                continue;
            }
            result.add(CodecUtil.of(codec, encodeTest.adapt(), decodeTest));
        }
        return result;
    }

    public static <T> TestedCodec<T> of(Codec<T> codec) {
        return new TestedCodec<Object>(codec, o -> TestedCodec.success(), (ops, input) -> TestedCodec.success());
    }

    public static <T> TestedCodec<T> of(Codec<T> codec, TestedCodec.EncodeTest<T> encodeTest) {
        return new TestedCodec<T>(codec, encodeTest, (ops, input) -> TestedCodec.success());
    }

    public static <T> TestedCodec<T> of(Codec<T> codec, TestedCodec.DecodeTest<?> decodeTest) {
        return new TestedCodec<Object>(codec, o -> TestedCodec.success(), decodeTest);
    }

    public static <T> TestedCodec<T> of(Codec<T> codec, TestedCodec.EncodeTest<T> encodeTest, TestedCodec.DecodeTest<?> decodeTest) {
        return new TestedCodec<T>(codec, encodeTest, decodeTest);
    }

    public static <T> MultiFieldCodec<T> fieldsOf(Codec<T> codec, String ... names) {
        LinkedHashMap map = new LinkedHashMap();
        TestedCodec<T> tested = CodecUtil.of(codec);
        for (String name : names) {
            map.put(name, tested);
        }
        return new MultiFieldCodec(map);
    }

    public static <T> MultiFieldCodec<T> fieldsOf(Map<String, TestedCodec<? extends T>> map) {
        return new MultiFieldCodec<T>(map);
    }

    public static <T> OptionalMultiFieldCodec<T> optionalFieldsOf(Codec<T> codec, String ... names) {
        LinkedHashMap map = new LinkedHashMap();
        TestedCodec<T> tested = CodecUtil.of(codec);
        for (String name : names) {
            map.put(name, tested);
        }
        return new OptionalMultiFieldCodec(map);
    }

    public static <T> OptionalMultiFieldCodec<T> optionalFieldsOf(Map<String, TestedCodec<? extends T>> map) {
        return new OptionalMultiFieldCodec<T>(map);
    }

    public static <T> MapCodec<T> optionalFieldsOf(Codec<T> codec, T def, String ... names) {
        LinkedHashMap<String, TestedCodec<T>> map = new LinkedHashMap<String, TestedCodec<T>>();
        TestedCodec<T> tested = CodecUtil.of(codec);
        for (String name : names) {
            map.put(name, tested);
        }
        return CodecUtil.optionalFieldsOf(map, def);
    }

    public static <T> MapCodec<T> optionalFieldsOf(Map<String, TestedCodec<? extends T>> map, T def) {
        return new OptionalMultiFieldCodec<T>(map).xmap(may -> may.orElse(def), t -> Objects.equals(t, def) ? Optional.empty() : Optional.of(t));
    }

    public static <B extends FriendlyByteBuf, T, I> StreamCodec<B, T> mapStream(Codec<I> codec, Function<? super I, ? extends T> parser, Function<? super T, ? extends I> getter) {
        StreamCodec<B, I> stream = CodecUtil.toStream(codec);
        return stream.map(parser, getter);
    }

    public static <B extends FriendlyByteBuf, T> StreamCodec<B, T> toStream(Codec<T> codec) {
        return StreamCodec.of((buf, inst) -> buf.writeJsonWithCodec(codec, inst), buf -> buf.readJsonWithCodec(codec));
    }

    public static <B extends FriendlyByteBuf, T> StreamCodec<B, T> toStream(MapCodec<T> codec) {
        return CodecUtil.toStream(codec.codec());
    }

    public static <T> Optional<RegistryOps<T>> getRegistryOps(DynamicOps<T> ops) {
        return CropariaIf.getRegistryAccess().map(access -> RegistryOps.create((DynamicOps)ops, (HolderLookup.Provider)access));
    }

    public static <T> DynamicOps<T> getOps(DynamicOps<T> ops) {
        return CodecUtil.getRegistryOps(ops).map(o -> o).orElse(ops);
    }

    public static <T> DataResult<JsonElement> encodeJson(T object, Codec<T> codec) {
        return codec.encodeStart(CodecUtil.getOps(JsonOps.INSTANCE), object);
    }

    public static <T> DataResult<JsonElement> encodeJson(T object, MapCodec<T> codec) {
        return CodecUtil.encodeJson(object, codec.codec());
    }

    public static <T> DataResult<JsonElement> dumpJson(T object, Codec<T> codec, Path path, boolean override) throws IOException {
        DataResult<JsonElement> result = CodecUtil.encodeJson(object, codec);
        if (result.isSuccess()) {
            FileUtil.write(path.toFile(), ((JsonElement)result.getOrThrow()).toString(), override);
        }
        return result;
    }

    public static <T> DataResult<JsonElement> dumpJson(T object, MapCodec<T> codec, Path path, boolean override) throws IOException, IllegalStateException {
        return CodecUtil.dumpJson(object, codec.codec(), path, override);
    }

    public static <T> DataResult<T> decodeJson(JsonElement element, Codec<T> codec) {
        return codec.decode(CodecUtil.getOps(JsonOps.INSTANCE), (Object)element).map(Pair::getFirst);
    }

    public static <T> DataResult<T> decodeJson(JsonElement element, MapCodec<T> codec) {
        return CodecUtil.decodeJson(element, codec.codec());
    }

    public static <T> DataResult<T> readJson(File file, Codec<T> codec) throws IOException {
        try (FileReader reader = new FileReader(file);){
            DataResult<T> dataResult = CodecUtil.decodeJson((JsonElement)GSON.fromJson((Reader)reader, JsonElement.class), codec);
            return dataResult;
        }
    }

    public static <T> DataResult<T> readJson(File file, MapCodec<T> codec) throws IOException {
        return CodecUtil.readJson(file, codec.codec());
    }

    public static <T> DataResult<T> readJson(String json, Codec<T> codec) {
        return CodecUtil.decodeJson((JsonElement)GSON.fromJson(json, JsonElement.class), codec);
    }

    public static <S, F1, T extends S> MapCodec<T> extend(MapCodec<S> superCodec, RecordCodecBuilder<T, F1> field1, BiFunction<S, F1, T> mapper) {
        return CodecUtil.extend(superCodec, List.of(field1), (S base, ArrayList<?> fields) -> mapper.apply(base, fields.getFirst()));
    }

    public static <S, F1, F2, T extends S> MapCodec<T> extend(MapCodec<S> superCodec, RecordCodecBuilder<T, F1> field1, RecordCodecBuilder<T, F2> field2, Function3<S, F1, F2, T> mapper) {
        return CodecUtil.extend(superCodec, List.of(field1, field2), (S base, ArrayList<?> fields) -> mapper.apply(base, fields.getFirst(), fields.get(1)));
    }

    public static <S, F1, F2, F3, T extends S> MapCodec<T> extend(MapCodec<S> superCodec, RecordCodecBuilder<T, F1> field1, RecordCodecBuilder<T, F2> field2, RecordCodecBuilder<T, F3> field3, Function4<S, F1, F2, F3, T> mapper) {
        return CodecUtil.extend(superCodec, List.of(field1, field2, field3), (S base, ArrayList<?> fields) -> mapper.apply(base, fields.getFirst(), fields.get(1), fields.get(2)));
    }

    public static <S, F1, F2, F3, F4, T extends S> MapCodec<T> extend(MapCodec<S> superCodec, RecordCodecBuilder<T, F1> field1, RecordCodecBuilder<T, F2> field2, RecordCodecBuilder<T, F3> field3, RecordCodecBuilder<T, F4> field4, Function5<S, F1, F2, F3, F4, T> mapper) {
        return CodecUtil.extend(superCodec, List.of(field1, field2, field3, field4), (S base, ArrayList<?> fields) -> mapper.apply(base, fields.getFirst(), fields.get(1), fields.get(2), fields.get(3)));
    }

    public static <S, F1, F2, F3, F4, F5, T extends S> MapCodec<T> extend(MapCodec<S> superCodec, RecordCodecBuilder<T, F1> field1, RecordCodecBuilder<T, F2> field2, RecordCodecBuilder<T, F3> field3, RecordCodecBuilder<T, F4> field4, RecordCodecBuilder<T, F5> field5, Function6<S, F1, F2, F3, F4, F5, T> mapper) {
        return CodecUtil.extend(superCodec, List.of(field1, field2, field3, field4, field5), (S base, ArrayList<?> fields) -> mapper.apply(base, fields.getFirst(), fields.get(1), fields.get(2), fields.get(3), fields.get(4)));
    }

    public static <S, F1, F2, F3, F4, F5, F6, T extends S> MapCodec<T> extend(MapCodec<S> superCodec, RecordCodecBuilder<T, F1> field1, RecordCodecBuilder<T, F2> field2, RecordCodecBuilder<T, F3> field3, RecordCodecBuilder<T, F4> field4, RecordCodecBuilder<T, F5> field5, RecordCodecBuilder<T, F6> field6, Function7<S, F1, F2, F3, F4, F5, F6, T> mapper) {
        return CodecUtil.extend(superCodec, List.of(field1, field2, field3, field4, field5, field6), (S base, ArrayList<?> fields) -> mapper.apply(base, fields.getFirst(), fields.get(1), fields.get(2), fields.get(3), fields.get(4), fields.get(5)));
    }

    public static <S, F1, F2, F3, F4, F5, F6, F7, T extends S> MapCodec<T> extend(MapCodec<S> superCodec, RecordCodecBuilder<T, F1> field1, RecordCodecBuilder<T, F2> field2, RecordCodecBuilder<T, F3> field3, RecordCodecBuilder<T, F4> field4, RecordCodecBuilder<T, F5> field5, RecordCodecBuilder<T, F6> field6, RecordCodecBuilder<T, F7> field7, Function8<S, F1, F2, F3, F4, F5, F6, F7, T> mapper) {
        return CodecUtil.extend(superCodec, List.of(field1, field2, field3, field4, field5, field6, field7), (S base, ArrayList<?> fields) -> mapper.apply(base, fields.getFirst(), fields.get(1), fields.get(2), fields.get(3), fields.get(4), fields.get(5), fields.get(6)));
    }

    public static <S, F1, F2, F3, F4, F5, F6, F7, F8, T extends S> MapCodec<T> extend(MapCodec<S> superCodec, RecordCodecBuilder<T, F1> field1, RecordCodecBuilder<T, F2> field2, RecordCodecBuilder<T, F3> field3, RecordCodecBuilder<T, F4> field4, RecordCodecBuilder<T, F5> field5, RecordCodecBuilder<T, F6> field6, RecordCodecBuilder<T, F7> field7, RecordCodecBuilder<T, F8> field8, Function9<S, F1, F2, F3, F4, F5, F6, F7, F8, T> mapper) {
        return CodecUtil.extend(superCodec, List.of(field1, field2, field3, field4, field5, field6, field7, field8), (S base, ArrayList<?> fields) -> mapper.apply(base, fields.getFirst(), fields.get(1), fields.get(2), fields.get(3), fields.get(4), fields.get(5), fields.get(6), fields.get(7)));
    }

    @SafeVarargs
    public static <S, T extends S> MapCodec<T> extend(MapCodec<S> superCodec, ResultMapper<S, T> resultMapper, RecordCodecBuilder<T, ?> ... fieldCodecs) {
        return CodecUtil.extend(superCodec, Arrays.asList(fieldCodecs), resultMapper);
    }

    public static <S, T extends S> MapCodec<T> extend(final MapCodec<S> superCodec, final Collection<RecordCodecBuilder<T, ?>> fieldCodecs, final ResultMapper<S, T> resultMapper) {
        return MapCodec.of((MapEncoder)new MapEncoder.Implementation<T>(){

            public <O> RecordBuilder<O> encode(T input, DynamicOps<O> ops, RecordBuilder<O> prefix) {
                superCodec.encode(input, ops, prefix);
                for (RecordCodecBuilder fieldCodec : fieldCodecs) {
                    MapEncoder encoder = RecordCodecBuilderReflection.getEncoder(fieldCodec, input);
                    Function getter = RecordCodecBuilderReflection.getGetter(fieldCodec);
                    Object field = getter.apply(input);
                    encoder.encode(field, ops, prefix);
                }
                return prefix;
            }

            public <O> Stream<O> keys(DynamicOps<O> ops) {
                ArrayList keys = new ArrayList();
                superCodec.keys(ops).forEach(keys::add);
                for (RecordCodecBuilder fieldCodec : fieldCodecs) {
                    MapDecoder decoder = RecordCodecBuilderReflection.getDecoder(fieldCodec);
                    decoder.keys(ops).forEach(keys::add);
                }
                keys.trimToSize();
                return keys.stream();
            }
        }, (MapDecoder)new MapDecoder.Implementation<T>(){

            public <I> DataResult<T> decode(DynamicOps<I> ops, MapLike<I> input) {
                DataResult superResult = superCodec.decode(ops, input);
                if (superResult.isError()) {
                    return superResult.flatMap(s -> DataResult.error(() -> "Failed to decode super: " + String.valueOf(s)));
                }
                ArrayList<Object> fields = new ArrayList<Object>();
                for (RecordCodecBuilder fieldCodec : fieldCodecs) {
                    MapDecoder decoder = RecordCodecBuilderReflection.getDecoder(fieldCodec);
                    DataResult result = decoder.decode(ops, input);
                    if (result.isError()) {
                        return result.flatMap(f -> DataResult.error(() -> "Failed to decode field: " + String.valueOf(f)));
                    }
                    fields.add(result.getOrThrow());
                }
                return DataResult.success(resultMapper.apply(superResult.getOrThrow(), fields));
            }

            public <O> Stream<O> keys(DynamicOps<O> ops) {
                ArrayList keys = new ArrayList();
                superCodec.keys(ops).forEach(keys::add);
                for (RecordCodecBuilder fieldCodec : fieldCodecs) {
                    MapDecoder decoder = RecordCodecBuilderReflection.getDecoder(fieldCodec);
                    decoder.keys(ops).forEach(keys::add);
                }
                keys.trimToSize();
                return keys.stream();
            }
        });
    }

    public static interface ResultMapper<S, T extends S>
    extends BiFunction<S, ArrayList<?>, T> {
        @Override
        public T apply(S var1, ArrayList<?> var2);
    }
}

