/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import cool.muyucloud.croparia.api.codec.TestedCodec;
import java.util.ArrayList;
import java.util.function.Supplier;

public class MultiCodec<T>
extends ArrayList<TestedCodec<? extends T>>
implements Codec<T> {
    public <I> DataResult<Pair<T, I>> decode(DynamicOps<I> ops, I toDecode) {
        ArrayList logs = new ArrayList(this.size());
        for (TestedCodec codec : this) {
            TestedCodec adapted = codec.adapt();
            DataResult result = adapted.decode(ops, toDecode);
            if (result.isSuccess()) {
                return result;
            }
            result.error().ifPresent(error -> logs.add(error.messageSupplier()));
        }
        return DataResult.error(() -> MultiCodec.buildMsg(logs));
    }

    public <O> DataResult<O> encode(T toEncode, DynamicOps<O> ops, O prefix) {
        ArrayList logs = new ArrayList(this.size());
        for (TestedCodec codec : this) {
            DataResult<O> result = codec.adapt().encode(toEncode, ops, prefix);
            if (result.isSuccess()) {
                return result;
            }
            result.error().ifPresent(error -> logs.add(error.messageSupplier()));
        }
        return DataResult.error(() -> MultiCodec.buildMsg(logs));
    }

    public static String buildMsg(Iterable<Supplier<String>> logs) {
        StringBuilder builder = new StringBuilder("Failed to apply any of the provided codecs:");
        for (Supplier<String> log : logs) {
            builder.append("\n").append(log.get());
        }
        return builder.toString();
    }
}

