/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.block;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.component.TargetPos;
import cool.muyucloud.croparia.api.core.entity.FakePlayer;
import cool.muyucloud.croparia.api.core.recipe.container.RitualContainer;
import cool.muyucloud.croparia.api.core.recipe.container.RitualStructureContainer;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.registry.Recipes;
import cool.muyucloud.croparia.util.CifUtil;
import cool.muyucloud.croparia.util.ItemPlaceable;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class RitualStand
extends Block
implements ItemPlaceable {
    public static final Map<TargetPos, Set<ItemEntity>> CACHED_ITEMS = new HashMap<TargetPos, Set<ItemEntity>>();
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.3, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private final int tier;

    public RitualStand(int tier, BlockBehaviour.Properties properties) {
        super(properties);
        this.tier = tier;
    }

    @NotNull
    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (hand == InteractionHand.MAIN_HAND) {
            if (itemStack.getItem() == CropariaItems.RECIPE_WIZARD.get()) {
                return InteractionResult.PASS;
            }
            this.placeItem(world, pos, itemStack, (Entity)player);
            return InteractionResult.CONSUME;
        }
        return super.useItemOn(itemStack, blockState, world, pos, player, hand, blockHitResult);
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (CropariaIf.CONFIG.getRitual().booleanValue() && world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                TargetPos targetPos = new TargetPos((Level)level, pos);
                Set cachedItems = CACHED_ITEMS.computeIfAbsent(targetPos, k -> Set.of()).stream().filter(item -> item.isAlive() && !item.getItem().isEmpty()).collect(Collectors.toSet());
                CACHED_ITEMS.put(targetPos, cachedItems);
                if (cachedItems.contains(itemEntity)) {
                    return;
                }
                cachedItems.add(itemEntity);
                RecipeManager recipeManager = level.getServer().getRecipeManager();
                recipeManager.getRecipeFor(Recipes.RITUAL_STRUCTURE, (RecipeInput)new RitualStructureContainer(level.getBlockState(pos)), (Level)level).map(RecipeHolder::value).map(structure -> structure.validate(pos, (Level)level)).ifPresentOrElse(r -> r.ifSuccessOrElse(matched -> {
                    RitualContainer matcher = RitualContainer.of(level.getBlockState(pos), cachedItems, matched);
                    recipeManager.getRecipeFor(Recipes.RITUAL, (RecipeInput)matcher, (Level)level).map(RecipeHolder::value).ifPresentOrElse(ritual -> {
                        Player player;
                        ItemStack result = ritual.assemble(matcher);
                        if (result.getItem() instanceof SpawnEggItem) {
                            FakePlayer.useAllItemsOn(level, pos.above(), result);
                        }
                        cachedItems.remove(itemEntity);
                        Entity patt0$temp = itemEntity.getOwner();
                        CifUtil.exportItem((Level)level, pos, result, patt0$temp instanceof Player ? (player = (Player)patt0$temp) : null);
                        this.playSound(level, pos);
                    }, () -> this.tryTell(itemEntity, (Component)Texts.translatable("overlay.croparia.ritual.rejected", new Object[0])));
                }, () -> this.tryTell(itemEntity, (Component)Texts.translatable("overlay.croparia.ritual.bad", new Object[0]))), () -> this.tryTell(itemEntity, (Component)Texts.translatable("overlay.croparia.ritual.404", new Object[0])));
            }
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        TargetPos targetPos = new TargetPos(level, pos);
        CACHED_ITEMS.remove(targetPos);
    }

    protected void tryTell(ItemEntity item, Component msg) {
        Entity entity = item.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Texts.overlay(player, msg);
        }
    }

    protected void playSound(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        level.playSound(null, pos, SoundEvent.createVariableRangeEvent((ResourceLocation)CropariaIf.of("block.ritual.craft")), SoundSource.BLOCKS);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public int getTier() {
        return this.tier;
    }
}

