/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import cool.muyucloud.croparia.api.core.block.ActivatedShrieker;
import cool.muyucloud.croparia.registry.BlockEntities;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.OptionalInt;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ActivatedShriekerBlockEntity
extends BlockEntity
implements GameEventListener.Provider<VibrationSystem.Listener>,
VibrationSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Int2ObjectMap<SoundEvent> SOUND_BY_LEVEL = (Int2ObjectMap)Util.make((Object)new Int2ObjectOpenHashMap(), map -> {
        map.put(1, (Object)SoundEvents.WARDEN_NEARBY_CLOSE);
        map.put(2, (Object)SoundEvents.WARDEN_NEARBY_CLOSER);
        map.put(3, (Object)SoundEvents.WARDEN_NEARBY_CLOSEST);
        map.put(4, (Object)SoundEvents.WARDEN_LISTENING_ANGRY);
    });
    private final VibrationSystem.User vibrationUser = new VibrationUser();
    private VibrationSystem.Data vibrationData = new VibrationSystem.Data();
    private final VibrationSystem.Listener vibrationListener = new VibrationSystem.Listener((VibrationSystem)this);

    public ActivatedShriekerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntities.ACTIVATED_SHRIEKER.get(), blockPos, blockState);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull VibrationSystem.Data getVibrationData() {
        return this.vibrationData;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull VibrationSystem.User getVibrationUser() {
        return this.vibrationUser;
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        RegistryOps registryOps = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (compoundTag.contains("listener", 10)) {
            VibrationSystem.Data.CODEC.parse((DynamicOps)registryOps, (Object)compoundTag.getCompound("listener")).resultOrPartial(string -> LOGGER.error("Failed to parse vibration listener for Sculk Shrieker: '{}'", string)).ifPresent(data -> {
                this.vibrationData = data;
            });
        }
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        RegistryOps registryOps = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        VibrationSystem.Data.CODEC.encodeStart((DynamicOps)registryOps, (Object)this.vibrationData).resultOrPartial(string -> LOGGER.error("Failed to encode vibration listener for Sculk Shrieker: '{}'", string)).ifPresent(tag -> compoundTag.put("listener", tag));
    }

    @Nullable
    public static ServerPlayer tryGetPlayer(@Nullable Entity entity) {
        ItemEntity itemEntity;
        Projectile projectile;
        Entity owner;
        LivingEntity passenger;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer;
        }
        if (entity != null && (passenger = entity.getControllingPassenger()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)passenger;
            return serverPlayer;
        }
        if (entity instanceof Projectile && (owner = (projectile = (Projectile)entity).getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)owner;
            return serverPlayer;
        }
        if (entity instanceof ItemEntity && (owner = (itemEntity = (ItemEntity)entity).getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)owner;
            return serverPlayer;
        }
        return null;
    }

    public void tryShriek(ServerLevel serverLevel, @Nullable ServerPlayer serverPlayer) {
        BlockState blockState;
        if (!(serverPlayer == null || ((Boolean)(blockState = this.getBlockState()).getValue((Property)ActivatedShrieker.SHRIEKING)).booleanValue() || this.canRespond(serverLevel) && !this.tryToWarn(serverLevel, serverPlayer))) {
            this.shriek(serverLevel, (Entity)serverPlayer);
        }
    }

    private boolean tryToWarn(ServerLevel serverLevel, ServerPlayer serverPlayer) {
        OptionalInt optionalInt = WardenSpawnTracker.tryWarn((ServerLevel)serverLevel, (BlockPos)this.getBlockPos(), (ServerPlayer)serverPlayer);
        return optionalInt.isPresent();
    }

    private void shriek(ServerLevel serverLevel, @Nullable Entity entity) {
        BlockPos blockPos = this.getBlockPos();
        BlockState blockState = this.getBlockState();
        serverLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)ActivatedShrieker.SHRIEKING, (Comparable)Boolean.valueOf(true)), 2);
        serverLevel.scheduleTick(blockPos, blockState.getBlock(), 90);
        serverLevel.levelEvent(3007, blockPos, 0);
        serverLevel.gameEvent((Holder)GameEvent.SHRIEK, blockPos, GameEvent.Context.of((Entity)entity));
    }

    private boolean canRespond(ServerLevel serverLevel) {
        return (Boolean)this.getBlockState().getValue((Property)ActivatedShrieker.CAN_SUMMON) != false && serverLevel.getDifficulty() != Difficulty.PEACEFUL && serverLevel.getGameRules().getBoolean(GameRules.RULE_DO_WARDEN_SPAWNING);
    }

    public void tryRespond(ServerLevel serverLevel) {
        if (this.canRespond(serverLevel)) {
            if (!this.trySummonWarden(serverLevel)) {
                this.playWardenReplySound((Level)serverLevel);
            }
            Warden.applyDarknessAround((ServerLevel)serverLevel, (Vec3)Vec3.atCenterOf((Vec3i)this.getBlockPos()), null, (int)40);
        }
    }

    private void playWardenReplySound(Level level) {
        SoundEvent soundEvent = (SoundEvent)SOUND_BY_LEVEL.get(4);
        if (soundEvent != null) {
            BlockPos blockPos = this.getBlockPos();
            int i = blockPos.getX() + Mth.randomBetweenInclusive((RandomSource)level.random, (int)-10, (int)10);
            int j = blockPos.getY() + Mth.randomBetweenInclusive((RandomSource)level.random, (int)-10, (int)10);
            int k = blockPos.getZ() + Mth.randomBetweenInclusive((RandomSource)level.random, (int)-10, (int)10);
            level.playSound(null, (double)i, (double)j, (double)k, soundEvent, SoundSource.HOSTILE, 5.0f, 1.0f);
        }
    }

    private boolean trySummonWarden(ServerLevel serverLevel) {
        return SpawnUtil.trySpawnMob((EntityType)EntityType.WARDEN, (EntitySpawnReason)EntitySpawnReason.TRIGGERED, (ServerLevel)serverLevel, (BlockPos)this.getBlockPos(), (int)20, (int)5, (int)6, (SpawnUtil.Strategy)SpawnUtil.Strategy.ON_TOP_OF_COLLIDER, (boolean)false).isPresent();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull VibrationSystem.Listener getListener() {
        return this.vibrationListener;
    }

    private class VibrationUser
    implements VibrationSystem.User {
        private static final int LISTENER_RADIUS = 8;
        private final PositionSource positionSource;

        public VibrationUser() {
            this.positionSource = new BlockPositionSource(ActivatedShriekerBlockEntity.this.worldPosition);
        }

        public int getListenerRadius() {
            return 8;
        }

        @NotNull
        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        @NotNull
        public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.SHRIEKER_CAN_LISTEN;
        }

        public boolean canReceiveVibration(ServerLevel serverLevel, BlockPos blockPos, Holder<GameEvent> holder, GameEvent.Context context) {
            return (Boolean)ActivatedShriekerBlockEntity.this.getBlockState().getValue((Property)ActivatedShrieker.SHRIEKING) == false && ActivatedShriekerBlockEntity.tryGetPlayer(context.sourceEntity()) != null;
        }

        public void onReceiveVibration(ServerLevel serverLevel, BlockPos blockPos, Holder<GameEvent> holder, @Nullable Entity entity, @Nullable Entity entity2, float f) {
            ActivatedShriekerBlockEntity.this.tryShriek(serverLevel, ActivatedShriekerBlockEntity.tryGetPlayer(entity2 != null ? entity2 : entity));
        }

        public void onDataChanged() {
            ActivatedShriekerBlockEntity.this.setChanged();
        }

        public boolean requiresAdjacentChunksToBeTicking() {
            return true;
        }
    }
}

