/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.block.entity;

import cool.muyucloud.croparia.access.CropBlockAccess;
import cool.muyucloud.croparia.api.repo.ContainerRepo;
import cool.muyucloud.croparia.api.repo.RepoProxy;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import cool.muyucloud.croparia.registry.BlockEntities;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GreenhouseBlockEntity
extends BlockEntity
implements MenuProvider,
Container {
    private final NonNullList<ItemStack> inventory;
    private final RepoProxy<ItemSpec> proxy = RepoProxy.item(new ContainerRepo(this));

    public GreenhouseBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.GREENHOUSE_BE.get(), pos, state);
        this.inventory = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    }

    public static void tick(Level level, BlockPos worldPosition, GreenhouseBlockEntity gbe) {
        BlockState belowState;
        Block block;
        if (!level.isClientSide && (block = (belowState = level.getBlockState(worldPosition.below())).getBlock()) instanceof CropBlock) {
            CropBlock block2 = (CropBlock)block;
            Item seed = block2.asItem();
            if (block2.isMaxAge(belowState)) {
                List droppedStacks = Block.getDrops((BlockState)belowState, (ServerLevel)Objects.requireNonNull(level.getServer()).getLevel(level.dimension()), (BlockPos)worldPosition.below(), (BlockEntity)level.getBlockEntity(worldPosition.below()));
                boolean decreased = false;
                for (ItemStack stack : droppedStacks) {
                    if (!decreased && stack.is(seed)) {
                        stack.shrink(1);
                        decreased = true;
                    }
                    gbe.proxy.accept(ItemSpec.of(stack), stack.getCount());
                }
                IntegerProperty property = ((CropBlockAccess)block2).cif$getAgeProperty();
                int maxAge = block2.getMaxAge();
                level.setBlockAndUpdate(worldPosition.below(), (BlockState)block2.defaultBlockState().setValue((Property)property, (Comparable)Integer.valueOf(maxAge / 2)));
            }
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        super.saveAdditional(nbt, provider);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean isEmpty() {
        return this.inventory.stream().allMatch(ItemStack::isEmpty);
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.inventory, (int)slot, (int)amount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public boolean stillValid(Player player) {
        if (this.level == null || this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        this.inventory.clear();
    }

    @NotNull
    public Component getDisplayName() {
        return Component.nullToEmpty((String)"Greenhouse");
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new DispenserMenu(syncId, inv, (Container)this);
    }

    @Nullable
    public RepoProxy<ItemSpec> visitItem() {
        return this.proxy;
    }
}

