/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.registry.Crops;
import cool.muyucloud.croparia.registry.DgRegistries;
import cool.muyucloud.croparia.util.text.FailureMessenger;
import cool.muyucloud.croparia.util.text.SuccessMessenger;
import cool.muyucloud.croparia.util.text.Texts;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class DumpCommand {
    private static final LiteralArgumentBuilder<CommandSourceStack> DUMP = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dump").requires(s -> s.hasPermission(2))).executes(context -> DumpCommand.dumpAll((msg, broadcast) -> Texts.success((CommandSourceStack)context.getSource(), msg, broadcast), false))).then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> Crops.cropSuggestions(builder)).executes(context -> {
        ResourceLocation id = ResourceLocationArgument.getId((CommandContext)context, (String)"id");
        return DumpCommand.dump(id, Texts.success((CommandSourceStack)context.getSource()), Texts.failure((CommandSourceStack)context.getSource()), false);
    }));

    public static int dumpAll(SuccessMessenger success, boolean openFile) {
        int size = DgRegistries.CROPS.size();
        MutableComponent component = Texts.translatable("commands.croparia.dump.perform", size);
        if (openFile) {
            component.withStyle(Texts.openFile(CropariaIf.CONFIG.getFilePath().resolve("crops").toString()));
            component.withStyle(Texts.blockMouseBehavior());
        }
        success.send((Component)component, true);
        DgRegistries.CROPS.dumpCrops();
        return size;
    }

    public static int dump(ResourceLocation id, SuccessMessenger success, FailureMessenger failure, boolean openFile) {
        Optional<Crop> optional = DgRegistries.CROPS.forName(id);
        if (optional.isEmpty()) {
            MutableComponent component = Texts.translatable("commands.croparia.dump.singular.absent", id);
            failure.send((Component)component);
            return 0;
        }
        Path dumped = DgRegistries.CROPS.dumpCrop(optional.get());
        if (dumped != null) {
            MutableComponent nameComponent = Texts.literal(id.toString(), new Style[0]);
            if (openFile) {
                nameComponent.withStyle(Texts.openFile(dumped.toString()));
            }
            MutableComponent component = Texts.translatable("commands.croparia.dump.singular", id);
            success.send((Component)component, true);
            return 1;
        }
        failure.send((Component)Texts.translatable("commands.croparia.dump.singular.fail", id));
        return 0;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return DUMP;
    }
}

