/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TargetPos
implements TooltipProvider {
    public static final MapCodec<TargetPos> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("dim").forGetter(TargetPos::getDim), (App)BlockPos.CODEC.fieldOf("pos").forGetter(TargetPos::getPos)).apply((Applicative)instance, TargetPos::new));
    public static final DataComponentType<TargetPos> TYPE = DataComponentType.builder().persistent(CODEC.codec()).build();
    @NotNull
    private final transient MutableComponent dimName;
    @NotNull
    private final transient ResourceKey<Level> dimKey;
    @NotNull
    private final BlockPos pos;
    private final transient MutableComponent tooltip;

    public TargetPos(@NotNull Entity entity) {
        this(entity.level(), entity.blockPosition());
    }

    public TargetPos(@NotNull Level level, @NotNull BlockPos pos) {
        this((ResourceKey<Level>)level.dimension(), pos);
    }

    public TargetPos(@NotNull ResourceKey<Level> dim, @NotNull BlockPos pos) {
        this.pos = pos;
        this.dimKey = dim;
        this.dimName = Texts.translatable("dimension.%s.%s".formatted(dim.location().getNamespace(), dim.location().getPath()), new Object[0]);
        this.tooltip = Texts.translatable("tooltip.croparia.bounded_position", this.getDimName(), this.getPos().getX(), this.getPos().getY(), this.getPos().getZ());
    }

    public TargetPos(@NotNull ResourceLocation dim, @NotNull BlockPos pos) {
        this.pos = pos;
        this.dimKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dim);
        this.dimName = Texts.translatable("dimension.%s.%s".formatted(dim.getNamespace(), dim.getPath()), new Object[0]);
        this.tooltip = Texts.translatable("tooltip.croparia.bounded_position", this.getDimName(), this.getPos().getX(), this.getPos().getY(), this.getPos().getZ());
    }

    @NotNull
    public ResourceLocation getDim() {
        return this.dimKey.location();
    }

    @NotNull
    public MutableComponent getDimName() {
        return this.dimName;
    }

    @NotNull
    public ResourceKey<Level> getDimKey() {
        return this.dimKey;
    }

    public Optional<ServerLevel> getLevel(@NotNull MinecraftServer server) {
        return Optional.ofNullable(server.getLevel(this.getDimKey()));
    }

    @NotNull
    public BlockPos getPos() {
        return this.pos;
    }

    public MutableComponent getTooltip() {
        return this.tooltip;
    }

    public void addToTooltip(Item.TooltipContext tooltipContext, @NotNull Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        consumer.accept((Component)this.getTooltip());
    }

    public void teleport(@NotNull Entity entity, @NotNull MinecraftServer server) {
        this.getLevel(server).ifPresent(level -> entity.teleportTo(level, (double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), Relative.ROTATION, 0.0f, 0.0f, true));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetPos)) {
            return false;
        }
        TargetPos targetPos = (TargetPos)o;
        return Objects.equals(this.dimKey, targetPos.dimKey) && Objects.equals(this.pos, targetPos.pos);
    }

    public int hashCode() {
        return Objects.hash(this.dimKey, this.pos);
    }
}

