/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.item;

import com.google.common.collect.ImmutableList;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.block.Infusor;
import cool.muyucloud.croparia.api.core.recipe.RitualStructure;
import cool.muyucloud.croparia.api.core.recipe.container.RitualStructureContainer;
import cool.muyucloud.croparia.api.core.util.RecipeWizardGenerator;
import cool.muyucloud.croparia.api.element.Element;
import cool.muyucloud.croparia.api.generator.pack.PackHandler;
import cool.muyucloud.croparia.api.generator.util.JarJarEntry;
import cool.muyucloud.croparia.api.recipe.entry.BlockInput;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.util.FileUtil;
import cool.muyucloud.croparia.util.supplier.OnLoadSupplier;
import cool.muyucloud.croparia.util.text.Texts;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class RecipeWizard
extends Item {
    public static final ResourceLocation PACK_ID = CropariaIf.of("recipe_wizard");
    public static final OnLoadSupplier<Collection<RecipeWizardGenerator>> GENERATORS = OnLoadSupplier.of(() -> {
        for (JarJarEntry entry : PackHandler.getBuiltinGenerators(PACK_ID)) {
            String name = entry.getEntry().getName();
            String prefix = "data-generators/%s/%s/".formatted(PACK_ID.getNamespace(), PACK_ID.getPath());
            Path target = CropariaIf.CONFIG.getFilePath().resolve("recipe_wizard/generators").resolve(name.substring(prefix.length()));
            try {
                entry.forInputStream(inputStream -> {
                    try (FileOutputStream outputStream = new FileOutputStream(target.toFile());){
                        inputStream.transferTo(outputStream);
                        outputStream.flush();
                    }
                });
            }
            catch (IOException e) {
                CropariaIf.LOGGER.error("Failed to move built-in recipe wizard template from %s to %s".formatted(name, target), (Throwable)e);
            }
        }
        ArrayList generators = new ArrayList();
        try {
            FileUtil.forFilesIn(CropariaIf.CONFIG.getFilePath().resolve("recipe_wizard/generators").toFile(), file -> RecipeWizardGenerator.read(file).ifPresent(generator -> {
                if (generator.isEnabled()) {
                    generators.add(generator);
                }
            }));
        }
        catch (IOException e) {
            CropariaIf.LOGGER.error("Failed to read recipe wizard generators", (Throwable)e);
        }
        return ImmutableList.copyOf(generators);
    });
    public static final Map<BlockInput, Function<UseOnContext, InteractionResult>> OPERATIONS = new HashMap<BlockInput, Function<UseOnContext, InteractionResult>>();

    public RecipeWizard(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player == null || context.getHand() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (player.isCrouching()) {
            for (Map.Entry<BlockInput, Function<UseOnContext, InteractionResult>> entry : OPERATIONS.entrySet()) {
                InteractionResult result;
                if (!entry.getKey().matches(level.getBlockState(context.getClickedPos())) || (result = entry.getValue().apply(context)) instanceof InteractionResult.Pass) continue;
                return result;
            }
        }
        if (!level.isClientSide() || !player.isLocalPlayer()) {
            return InteractionResult.PASS;
        }
        BlockState target = context.getLevel().getBlockState(context.getClickedPos());
        for (RecipeWizardGenerator generator : GENERATORS.get()) {
            if (!generator.matches(target)) continue;
            generator.handle(context);
            player.getCooldowns().addCooldown(context.getItemInHand(), 5);
            return InteractionResult.SUCCESS;
        }
        Texts.overlay(player, (Component)Texts.translatable("overlay.croparia.recipe_wizard.error.no_match", new Object[0]));
        return InteractionResult.PASS;
    }

    static {
        OPERATIONS.put(BlockInput.ofTag((TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"croparia:ritual_stands"))), context -> {
            BlockState state = context.getLevel().getBlockState(context.getClickedPos());
            return RitualStructure.TYPED_SERIALIZER.find(new RitualStructureContainer(state), context.getLevel()).map(structure -> {
                structure.tryBuild(context.getLevel(), context.getClickedPos());
                return InteractionResult.SUCCESS;
            }).orElse((InteractionResult)InteractionResult.PASS);
        });
        OPERATIONS.put(BlockInput.of(CropariaBlocks.INFUSOR.getId()), context -> {
            BlockState state = context.getLevel().getBlockState(context.getClickedPos());
            int i = (Infusor.ELEMENT.getInternalIndex((Enum)((Element)state.getValue(Infusor.ELEMENT))) + 1) % Infusor.ELEMENT.getPossibleValues().size();
            Element element = (Element)Infusor.ELEMENT.getPossibleValues().get(i);
            context.getLevel().setBlockAndUpdate(context.getClickedPos(), (BlockState)state.setValue(Infusor.ELEMENT, (Comparable)element));
            return InteractionResult.SUCCESS;
        });
    }
}

