/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.recipe.container.RitualContainer;
import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.api.recipe.TypedSerializer;
import cool.muyucloud.croparia.api.recipe.entry.BlockInput;
import cool.muyucloud.croparia.api.recipe.entry.ItemInput;
import cool.muyucloud.croparia.api.recipe.entry.ItemOutput;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.Constants;
import cool.muyucloud.croparia.util.supplier.Mappable;
import cool.muyucloud.croparia.util.text.Texts;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class RitualRecipe
implements DisplayableRecipe<RitualContainer> {
    public static final TypedSerializer<RitualRecipe> TYPED_SERIALIZER = new TypedSerializer<RitualRecipe>(CropariaIf.of("ritual"), RitualRecipe.class, RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockInput.CODEC.fieldOf("ritual").forGetter(RitualRecipe::getRitual), (App)BlockInput.CODEC.fieldOf("block").forGetter(RitualRecipe::getBlock), (App)ItemInput.CODEC.fieldOf("ingredient").forGetter(RitualRecipe::getIngredient), (App)ItemOutput.CODEC.fieldOf("result").forGetter(RitualRecipe::getResult)).apply((Applicative)instance, RitualRecipe::new)), TypedSerializer.JEI, Mappable.of(CropariaItems.RITUAL_STAND, item -> Texts.tooltip(item.getDefaultInstance(), Constants.TOOLTIP_RITUAL)), Mappable.of(CropariaItems.RITUAL_STAND_2, item -> Texts.tooltip(item.getDefaultInstance(), Constants.TOOLTIP_RITUAL)), Mappable.of(CropariaItems.RITUAL_STAND_3, item -> Texts.tooltip(item.getDefaultInstance(), Constants.TOOLTIP_RITUAL)));
    private final BlockInput ritual;
    @NotNull
    private final BlockInput block;
    @NotNull
    private final ItemInput ingredient;
    @NotNull
    private final ItemOutput result;

    public RitualRecipe(BlockInput ritual, @NotNull BlockInput state, @NotNull ItemInput ingredient, @NotNull ItemOutput result) {
        this.ritual = ritual;
        this.block = state;
        this.ingredient = ingredient;
        this.result = result;
        this.ritual.mapStacks(stacks -> {
            stacks.forEach(stack -> Texts.tooltip(stack, Constants.TOOLTIP_RITUAL));
            return stacks;
        });
        this.ingredient.mapStacks(stacks -> {
            stacks.forEach(stack -> Texts.tooltip(stack, Constants.ITEM_DROP_TOOLTIP));
            return stacks;
        });
        this.block.mapStacks(stacks -> {
            stacks.forEach(stack -> Texts.tooltip(stack, Constants.BLOCK_PLACE_TOOLTIP));
            return stacks;
        });
    }

    @NotNull
    public ItemInput getIngredient() {
        return this.ingredient;
    }

    @NotNull
    public ItemOutput getResult() {
        return this.result;
    }

    @NotNull
    public BlockInput getBlock() {
        return this.block;
    }

    @NotNull
    public BlockInput getRitual() {
        return this.ritual;
    }

    @Override
    @NotNull
    public List<List<ItemStack>> getInputs() {
        return List.of(this.getIngredient().getDisplayStacks(), this.getBlock().getDisplayStacks());
    }

    @Override
    @NotNull
    public List<List<ItemStack>> getOutputs() {
        ItemStack stack = this.getResult().getDisplayStack();
        if (stack.getItem() instanceof SpawnEggItem) {
            Texts.tooltip(stack, Texts.translatable("tooltip.croparia.spawn_egg", new Object[0]));
        } else if (stack.getItem() == Items.ENCHANTED_BOOK && this.getIngredient().getAmount() == 1L) {
            Texts.tooltip(stack, Texts.translatable("tooltip.croparia.ritual.enchant", stack.getCount()));
        }
        return List.of(List.of(this.getResult().getDisplayStack()));
    }

    public ItemStack assemble(RitualContainer matcher) {
        ItemStack result = this.getResult().createStack();
        ItemEnchantments enchantments = (ItemEnchantments)result.get(DataComponents.STORED_ENCHANTMENTS);
        if (this.getIngredient().getAmount() == 1L && result.getItem() == Items.ENCHANTED_BOOK && enchantments != null) {
            for (ItemStack stack : matcher.stacks()) {
                if (!this.getIngredient().matchType(stack)) continue;
                matcher.matched().destroy();
                ItemStack toEnchant = stack.copyWithCount(1);
                stack.shrink(1);
                for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                    int level = toEnchant.getEnchantments().getLevel((Holder)entry.getKey());
                    toEnchant.enchant((Holder)entry.getKey(), Math.min(level + result.getCount(), entry.getIntValue()));
                }
                return toEnchant;
            }
            return ItemStack.EMPTY;
        }
        long consumed = 0L;
        for (ItemStack stack : matcher.stacks()) {
            if (this.getIngredient().matchType(stack)) {
                long toConsume = Math.min((long)stack.getCount(), this.getIngredient().getAmount() - consumed);
                stack.shrink(Math.toIntExact(toConsume));
                consumed += toConsume;
            }
            if (consumed < this.getIngredient().getAmount()) continue;
            matcher.matched().destroy();
            return this.getResult().createStack();
        }
        return ItemStack.EMPTY;
    }

    public boolean matches(RitualContainer matcher) {
        ItemStack result = this.getResult().createStack();
        ItemEnchantments enchantments = (ItemEnchantments)result.get(DataComponents.STORED_ENCHANTMENTS);
        if (this.getIngredient().getAmount() == 1L && result.getItem() == Items.ENCHANTED_BOOK && enchantments != null) {
            return matcher.stacks().stream().anyMatch(stack -> {
                ItemEnchantments toCheck = stack.getEnchantments();
                return enchantments.entrySet().stream().anyMatch(entry -> toCheck.getLevel((Holder)entry.getKey()) < entry.getIntValue()) && this.getIngredient().matches((ItemStack)stack);
            }) && matcher.matched().getStates().stream().allMatch(state -> this.getBlock().matches((BlockState)state));
        }
        long accumulated = 0L;
        for (ItemStack stack2 : matcher.stacks()) {
            if (this.getIngredient().matchType(stack2)) {
                accumulated += (long)stack2.getCount();
            }
            if (accumulated < this.getIngredient().getAmount()) continue;
            return matcher.matched().getStates().stream().allMatch(state -> this.getBlock().matches((BlockState)state)) && this.getRitual().matches(matcher.ritual());
        }
        return false;
    }

    public boolean matches(RitualContainer container, Level level) {
        return this.matches(container);
    }

    @NotNull
    public ItemStack assemble(RitualContainer recipeInput, HolderLookup.Provider provider) {
        return this.assemble(recipeInput);
    }

    @Override
    @NotNull
    public ItemOutput result() {
        return this.getResult();
    }

    @Override
    @NotNull
    public BlockInput craftingStation() {
        return this.getRitual();
    }

    @Override
    public TypedSerializer<? extends DisplayableRecipe<RitualContainer>> getTypedSerializer() {
        return TYPED_SERIALIZER;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RitualRecipe)) {
            return false;
        }
        RitualRecipe that = (RitualRecipe)o;
        return Objects.equals(this.ritual, that.ritual) && Objects.equals(this.block, that.block) && Objects.equals(this.ingredient, that.ingredient) && Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        return Objects.hash(this.ritual, this.block, this.ingredient, this.result);
    }
}

