/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.access.AbstractFurnaceBlockEntityAccess;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.core.block.Infusor;
import cool.muyucloud.croparia.api.core.block.RitualStand;
import cool.muyucloud.croparia.api.core.recipe.RitualStructure;
import cool.muyucloud.croparia.api.core.recipe.container.RitualStructureContainer;
import cool.muyucloud.croparia.api.core.util.ReplaceException;
import cool.muyucloud.croparia.api.element.Element;
import cool.muyucloud.croparia.api.generator.util.DgReader;
import cool.muyucloud.croparia.api.placeholder.Placeholder;
import cool.muyucloud.croparia.api.placeholder.PlaceholderException;
import cool.muyucloud.croparia.api.placeholder.Template;
import cool.muyucloud.croparia.api.placeholder.TypeMapper;
import cool.muyucloud.croparia.api.recipe.entry.BlockInput;
import cool.muyucloud.croparia.api.recipe.entry.BlockOutput;
import cool.muyucloud.croparia.api.recipe.entry.ItemOutput;
import cool.muyucloud.croparia.registry.Recipes;
import cool.muyucloud.croparia.util.Dependencies;
import cool.muyucloud.croparia.util.FileUtil;
import cool.muyucloud.croparia.util.text.Texts;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public class RecipeWizardGenerator {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss");
    protected static final Map<ResourceLocation, ArrayList<Placeholder<UseOnContext>>> EXTENSIONS = new HashMap<ResourceLocation, ArrayList<Placeholder<UseOnContext>>>();
    public static final Placeholder<UseOnContext> TIMESTAMP = RecipeWizardGenerator.register(ResourceLocation.parse((String)"default"), Pattern.compile("^datetime$"), TypeMapper.of(context -> LocalDateTime.now().format(FORMATTER)));
    public static final Placeholder<UseOnContext> MAIN_HAND = RecipeWizardGenerator.register(ResourceLocation.parse((String)"default"), Pattern.compile("^main_hand$"), TypeMapper.of(context -> {
        ItemStack stack = Objects.requireNonNull(context.getPlayer()).getItemInHand(InteractionHand.MAIN_HAND);
        if (stack.isEmpty()) {
            Texts.overlay(context.getPlayer(), (Component)Texts.translatable("overlay.croparia.recipe_wizard.default.missing.main_hand", new Object[0]));
            throw new ReplaceException();
        }
        return ItemOutput.of(stack);
    }), Placeholder.ITEM_OUTPUT);
    public static final Placeholder<UseOnContext> OFF_HAND = RecipeWizardGenerator.register(ResourceLocation.parse((String)"default"), Pattern.compile("^off_hand$"), TypeMapper.of(context -> {
        ItemStack stack = Objects.requireNonNull(context.getPlayer()).getItemInHand(InteractionHand.OFF_HAND);
        if (stack.isEmpty()) {
            Texts.overlay(context.getPlayer(), (Component)Texts.translatable("overlay.croparia.recipe_wizard.default.missing.off_hand", new Object[0]));
            throw new ReplaceException();
        }
        return ItemOutput.of(stack);
    }), Placeholder.ITEM_OUTPUT);
    public static final Placeholder<UseOnContext> ITEM = RecipeWizardGenerator.register(ResourceLocation.parse((String)"default"), Pattern.compile("^item$"), TypeMapper.of(context -> {
        List entities = context.getLevel().getEntities(EntityTypeTest.forClass(ItemEntity.class), AABB.encapsulatingFullBlocks((BlockPos)context.getClickedPos(), (BlockPos)context.getClickedPos().above()), item -> !item.getItem().isEmpty());
        if (entities.isEmpty()) {
            assert (context.getPlayer() != null);
            Texts.overlay(context.getPlayer(), (Component)Texts.translatable("overlay.croparia.recipe_wizard.default.missing.target_item", new Object[0]));
            throw new ReplaceException();
        }
        return ItemOutput.of(((ItemEntity)entities.getFirst()).getItem());
    }), Placeholder.ITEM_OUTPUT);
    public static final Placeholder<UseOnContext> BLOCK = RecipeWizardGenerator.register(ResourceLocation.parse((String)"default"), Pattern.compile("^block$"), TypeMapper.of(context -> {
        Level level = context.getLevel();
        BlockState block = level.getBlockState(context.getClickedPos());
        if (block.isAir()) {
            assert (context.getPlayer() != null);
            Texts.overlay(context.getPlayer(), (Component)Texts.translatable("overlay.croparia.recipe_wizard.default.missing.block", new Object[0]));
            throw new ReplaceException();
        }
        return BlockOutput.of(block);
    }), Placeholder.BLOCK_OUTPUT);
    public static final Placeholder<UseOnContext> NEIGHBOR = RecipeWizardGenerator.register(ResourceLocation.parse((String)"default"), Pattern.compile("^neighbor$"), TypeMapper.of(context -> {
        Level level = context.getLevel();
        for (Direction direction : Direction.values()) {
            BlockState state;
            if (direction == Direction.UP || direction == Direction.DOWN || (state = level.getBlockState(context.getClickedPos().offset(direction.getUnitVec3i()))).isAir()) continue;
            return BlockOutput.of(state);
        }
        assert (context.getPlayer() != null);
        Texts.overlay(context.getPlayer(), (Component)Texts.translatable("overlay.croparia.recipe_wizard.default.missing.neighbor", new Object[0]));
        throw new ReplaceException();
    }), Placeholder.BLOCK_OUTPUT);
    public static final Placeholder<UseOnContext> BELOW = RecipeWizardGenerator.register(ResourceLocation.parse((String)"default"), Pattern.compile("^below$"), TypeMapper.of(context -> {
        Level level = context.getLevel();
        BlockState state = level.getBlockState(context.getClickedPos().below());
        if (state.isAir()) {
            assert (context.getPlayer() != null);
            Texts.overlay(context.getPlayer(), (Component)Texts.translatable("overlay.croparia.recipe_wizard.default.missing.block", new Object[0]));
            throw new ReplaceException();
        }
        return BlockOutput.of(state);
    }), Placeholder.BLOCK_OUTPUT);
    public static final Placeholder<UseOnContext> INFUSOR_ELEMENT = RecipeWizardGenerator.register(CropariaIf.of("infusor"), Pattern.compile("^infusor_element$"), TypeMapper.of(context -> {
        Element element;
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.getBlock() instanceof Infusor && (element = (Element)state.getValue(Infusor.ELEMENT)) != Element.EMPTY) {
            return element.getSerializedName();
        }
        assert (context.getPlayer() != null);
        Texts.overlay(context.getPlayer(), (Component)Texts.translatable("overlay.croparia.recipe_wizard.infusor.missing.element", new Object[0]));
        throw new ReplaceException();
    }));
    public static final Placeholder<UseOnContext> RITUAL_INPUT = RecipeWizardGenerator.register(CropariaIf.of("ritual"), Pattern.compile("^ritual_input$"), TypeMapper.of(context -> {
        RitualStructureContainer container;
        Optional<RitualStructure> structure;
        Optional input;
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (state.getBlock() instanceof RitualStand && (input = (structure = Recipes.RITUAL_STRUCTURE.find(container = new RitualStructureContainer(state), level)).flatMap(s -> s.validate(pos, level).getStates().stream().filter(candidate -> !candidate.isAir()).findFirst())).isPresent()) {
            return BlockOutput.of((BlockState)input.get());
        }
        assert (context.getPlayer() != null);
        Texts.overlay(context.getPlayer(), (Component)Texts.translatable("overlay.croparia.recipe_wizard.ritual.missing.block", new Object[0]));
        throw new ReplaceException();
    }), Placeholder.BLOCK_OUTPUT);
    public static final Placeholder<UseOnContext> SOAK_ELEMENT = RecipeWizardGenerator.register(CropariaIf.of("soak"), Pattern.compile("^soak_element$"), TypeMapper.of(context -> {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos().above());
        Block patt0$temp = state.getBlock();
        if (patt0$temp instanceof Infusor) {
            Infusor infusor = (Infusor)patt0$temp;
            Element element = (Element)state.getValue(Infusor.ELEMENT);
            return element.getSerializedName();
        }
        assert (context.getPlayer() != null);
        Texts.overlay(context.getPlayer(), (Component)Texts.translatable("overlay.croparia.recipe_wizard.soak.missing.element", new Object[0]));
        throw new ReplaceException();
    }));
    public static final Placeholder<UseOnContext> FURNACE_INPUT = RecipeWizardGenerator.register(ResourceLocation.parse((String)"furnace"), Pattern.compile("^furnace_input$"), TypeMapper.of(context -> {
        BlockEntity be = context.getLevel().getBlockEntity(context.getClickedPos());
        if (be instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)be;
            ItemStack stack = furnace.getItem(0);
            if (!stack.isEmpty()) {
                return ItemOutput.of(stack);
            }
            Texts.overlay(Objects.requireNonNull(context.getPlayer()), (Component)Texts.translatable("overlay.croparia.recipe_wizard.furnace.no_input", new Object[0]));
        } else {
            Texts.overlay(Objects.requireNonNull(context.getPlayer()), (Component)Texts.translatable("overlay.croparia.recipe_wizard.furnace.no_furnace", new Object[0]));
        }
        throw new ReplaceException();
    }), Placeholder.ITEM_OUTPUT);
    public static final Placeholder<UseOnContext> FURNACE_TIME = RecipeWizardGenerator.register(ResourceLocation.parse((String)"furnace"), Pattern.compile("^furnace_time$"), TypeMapper.of(context -> {
        BlockEntity be = context.getLevel().getBlockEntity(context.getClickedPos());
        if (!(be instanceof AbstractFurnaceBlockEntity)) {
            Texts.overlay(Objects.requireNonNull(context.getPlayer()), (Component)Texts.translatable("overlay.croparia.recipe_wizard.furnace.no_furnace", new Object[0]));
            throw new ReplaceException();
        }
        AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)be;
        ItemStack input = furnace.getItem(0);
        if (input.isEmpty()) {
            Texts.overlay(Objects.requireNonNull(context.getPlayer()), (Component)Texts.translatable("overlay.croparia.recipe_wizard.furnace.no_input", new Object[0]));
            throw new ReplaceException();
        }
        ItemStack fuel = furnace.getItem(1);
        if (fuel.isEmpty()) {
            Texts.overlay(Objects.requireNonNull(context.getPlayer()), (Component)Texts.translatable("overlay.croparia.recipe_wizard.furnace.no_fuel", new Object[0]));
            throw new ReplaceException();
        }
        return String.valueOf(((AbstractFurnaceBlockEntityAccess)furnace).cif$getBurnDuration(context.getLevel(), fuel) * fuel.getCount());
    }));
    public static final MapCodec<RecipeWizardGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)true).forGetter(RecipeWizardGenerator::isEnabled), (App)Dependencies.CODEC.optionalFieldOf("dependencies", (Object)Dependencies.EMPTY).forGetter(RecipeWizardGenerator::getDependencies), (App)BlockInput.CODEC.fieldOf("block").forGetter(RecipeWizardGenerator::getBlock), (App)Template.CODEC.fieldOf("path").forGetter(RecipeWizardGenerator::getPath), (App)CodecUtil.listOf(ResourceLocation.CODEC).optionalFieldOf("extensions", List.of()).forGetter(RecipeWizardGenerator::getExtensions), (App)Template.CODEC.fieldOf("template").forGetter(RecipeWizardGenerator::getTemplate)).apply((Applicative)instance, RecipeWizardGenerator::new));
    private final boolean enabled;
    private final Dependencies dependencies;
    private final BlockInput block;
    private final Template path;
    private final List<ResourceLocation> extensions;
    private final Template template;
    private final transient Placeholder<UseOnContext> placeholder;

    public static Optional<RecipeWizardGenerator> read(File file) {
        try {
            JsonObject json = DgReader.read(file);
            if (!(json.isJsonObject() && !json.getAsJsonObject().has("dependencies") || ((Boolean)CodecUtil.decodeJson(json.getAsJsonObject().get("dependencies"), Dependencies.CODEC).mapOrElse(Dependencies::available, e -> {
                CropariaIf.LOGGER.error("Failed to analyze dependencies of recipe wizard file %s".formatted(file));
                CropariaIf.LOGGER.error(e.message());
                return false;
            })).booleanValue())) {
                CropariaIf.LOGGER.warn("Skipped loading recipe wizard file %s due to missing or bad dependencies".formatted(file));
                return Optional.empty();
            }
            return (Optional)CodecUtil.decodeJson((JsonElement)json, CODEC).mapOrElse(Optional::of, error -> {
                CropariaIf.LOGGER.error("Failed to compile recipe wizard file %s".formatted(file), error);
                return Optional.empty();
            });
        }
        catch (JsonParseException | IOException e2) {
            CropariaIf.LOGGER.error("Failed to read recipe wizard file %s".formatted(file), e2);
            return Optional.empty();
        }
    }

    public static Placeholder<UseOnContext> register(ResourceLocation id, Placeholder<UseOnContext> placeholder) {
        ArrayList list = EXTENSIONS.computeIfAbsent(id, k -> new ArrayList());
        list.add(placeholder);
        list.trimToSize();
        return placeholder;
    }

    public static Placeholder<UseOnContext> register(ResourceLocation id, Pattern key, TypeMapper<UseOnContext, String> function) {
        return RecipeWizardGenerator.register(id, key, function, Placeholder.STRING);
    }

    public static <T> Placeholder<UseOnContext> register(ResourceLocation id, Pattern key, TypeMapper<UseOnContext, T> function, Placeholder<T> parser) {
        return RecipeWizardGenerator.register(id, Placeholder.build(builder -> builder.then(key, function, parser)));
    }

    protected static Collection<Placeholder<UseOnContext>> getExtensions(ResourceLocation id) {
        return EXTENSIONS.getOrDefault(id, new ArrayList());
    }

    public RecipeWizardGenerator(boolean enabled, Dependencies dependencies, BlockInput block, Template path, List<ResourceLocation> extensions, Template template) {
        ImmutableList immutable;
        this.enabled = enabled;
        this.dependencies = dependencies;
        this.block = block;
        this.path = path;
        this.extensions = extensions instanceof ImmutableList ? (immutable = (ImmutableList)extensions) : ImmutableList.copyOf(extensions);
        this.template = template;
        this.placeholder = Placeholder.build(builder -> {
            Collection<Placeholder<UseOnContext>> defaults = RecipeWizardGenerator.getExtensions(ResourceLocation.parse((String)"default"));
            for (Placeholder<UseOnContext> p : defaults) {
                builder.overwrite(p, TypeMapper.identity());
            }
            for (ResourceLocation id : this.getExtensions()) {
                Collection<Placeholder<UseOnContext>> extension = RecipeWizardGenerator.getExtensions(id);
                for (Placeholder<UseOnContext> p : extension) {
                    builder.overwrite(p, TypeMapper.identity());
                }
            }
            return builder;
        });
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BlockInput getBlock() {
        return this.block;
    }

    public Template getPath() {
        return this.path;
    }

    public Dependencies getDependencies() {
        return this.dependencies;
    }

    public List<ResourceLocation> getExtensions() {
        return this.extensions;
    }

    public Template getTemplate() {
        return this.template;
    }

    public Placeholder<UseOnContext> getPlaceholder() {
        return this.placeholder;
    }

    public boolean matches(BlockState state) {
        return this.getBlock().matches(state);
    }

    public void handle(UseOnContext context) {
        Player player = Objects.requireNonNull(context.getPlayer());
        if (this.isEnabled()) {
            try {
                String path = this.getPath().parse(context, this.getPlaceholder());
                String template = this.getTemplate().parse(context, this.getPlaceholder());
                Path result = CropariaIf.CONFIG.getRecipeWizard().resolve(path);
                FileUtil.write(result.toFile(), template, true);
                String s = result.toString();
                MutableComponent c = Texts.literal(s, new Style[0]).withStyle(Texts.openFile(s)).withStyle(Texts.inlineMouseBehavior());
                Texts.chat(player, (Component)Texts.translatable("chat.croparia.recipe_wizard.success", c));
            }
            catch (ReplaceException path) {
            }
            catch (PlaceholderException | IOException e) {
                Texts.chat(player, (Component)Texts.translatable("overlay.croparia.recipe_wizard.failed", new Object[0]).withStyle(ChatFormatting.RED));
                CropariaIf.LOGGER.error("Failed to generate recipe", (Throwable)e);
            }
        }
    }
}

