/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.crop.block;

import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.crop.CropAccess;
import cool.muyucloud.croparia.registry.DgRegistries;
import cool.muyucloud.croparia.util.text.Texts;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.NotNull;

public class CropariaCropBlock
extends CropBlock
implements CropAccess<Crop> {
    private final ResourceLocation cropId;

    public CropariaCropBlock(Crop crop) {
        super(BlockBehaviour.Properties.of().noCollission().sound(SoundType.CROP).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)crop.getBlockId())));
        this.cropId = crop.getKey();
    }

    @NotNull
    protected ItemLike getBaseSeedId() {
        return this.asItem();
    }

    @NotNull
    public MutableComponent getName() {
        MutableComponent cropName = Texts.translatable(this.getCrop().getTranslationKey(), new Object[0]);
        return Texts.translatable("block.croparia.crop.block", cropName);
    }

    public int getTier() {
        return this.getCrop().getTier();
    }

    @NotNull
    public Item asItem() {
        if (this.getCrop().getCropSeed().isEmpty()) {
            return Items.AIR;
        }
        return (Item)this.getCrop().getCropSeed().get();
    }

    @Override
    public Crop getCrop() {
        return DgRegistries.CROPS.forName(this.cropId).orElseThrow();
    }
}

