/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.crop.item;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.crop.CropAccess;
import cool.muyucloud.croparia.registry.DgRegistries;
import cool.muyucloud.croparia.registry.Tabs;
import cool.muyucloud.croparia.util.text.Texts;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import org.jetbrains.annotations.NotNull;

public class CropFruit
extends Item
implements CropAccess<Crop> {
    private final ResourceLocation cropId;

    public CropFruit(Crop crop) {
        super(new Item.Properties().arch$tab(Tabs.CROPS).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)crop.getFruitId())));
        this.cropId = crop.getKey();
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        if (!CropariaIf.CONFIG.getFruitUse().booleanValue()) {
            return InteractionResult.PASS;
        }
        if (!context.getLevel().isClientSide) {
            ItemStack material = this.getCrop().getResult();
            context.getLevel().addFreshEntity((Entity)new ItemEntity(context.getLevel(), (double)context.getClickedPos().getX() + 0.5, (double)(context.getClickedPos().getY() + 1), (double)context.getClickedPos().getZ() + 0.5, material.copy()));
            context.getItemInHand().shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public Component getName(ItemStack itemStack) {
        MutableComponent cropName = Texts.translatable(this.getCrop().getTranslationKey(), new Object[0]);
        return Texts.translatable("item.croparia.crop.fruit", cropName);
    }

    @Override
    public Crop getCrop() {
        return DgRegistries.CROPS.forName(this.cropId).orElseThrow();
    }
}

