/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.generator;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.generator.pack.PackHandler;
import cool.muyucloud.croparia.api.generator.util.DgEntry;
import cool.muyucloud.croparia.api.generator.util.DgListener;
import cool.muyucloud.croparia.api.generator.util.DgReader;
import cool.muyucloud.croparia.api.generator.util.DgRegistry;
import cool.muyucloud.croparia.api.placeholder.Template;
import cool.muyucloud.croparia.util.Dependencies;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class DataGenerator
implements DgListener {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceLocation, MapCodec<? extends DataGenerator>> REGISTRY = new HashMap<ResourceLocation, MapCodec<? extends DataGenerator>>();
    public static final MapCodec<DataGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("enabled").forGetter(DataGenerator::optionalEnabled), (App)Codec.BOOL.optionalFieldOf("startup").forGetter(DataGenerator::optionalStartup), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("whitelist").forGetter(DataGenerator::optionalWhitelist), (App)Template.CODEC.fieldOf("path").forGetter(DataGenerator::getPath), (App)DgRegistry.CODEC.fieldOf("registry").forGetter(DataGenerator::getRegistry), (App)Template.CODEC.fieldOf("template").forGetter(DataGenerator::getTemplate)).apply((Applicative)instance, (enabled, startup, whitelist, path, registry, template) -> new DataGenerator(enabled.orElse(true), startup.orElse(false), whitelist.orElse(List.of()), (Template)path, (DgRegistry<? extends DgEntry>)registry, (Template)template)));
    private final boolean enabled;
    private final boolean startup;
    private final List<ResourceLocation> whitelist;
    private final Template path;
    private final DgRegistry<? extends DgEntry> registry;
    private final Template template;

    public static <G extends DataGenerator, C extends MapCodec<G>> C register(ResourceLocation id, C codec) {
        REGISTRY.put(id, codec);
        return codec;
    }

    public static Optional<DataGenerator> read(File file) {
        try {
            JsonObject json = DgReader.read(file);
            JsonElement type = json.get("type");
            ResourceLocation id = ResourceLocation.parse((String)(type == null ? "croparia:generator" : type.getAsString()));
            JsonElement rawDependencies = json.get("dependencies");
            if (rawDependencies != null && !((Boolean)CodecUtil.decodeJson(rawDependencies, Dependencies.CODEC).mapOrElse(Dependencies::available, err -> {
                LOGGER.error("Failed to parse dependencies of data generator {}: {}", (Object)file, (Object)err.message());
                return false;
            })).booleanValue()) {
                LOGGER.debug("Skipped loading data generator {} due to missing dependencies", (Object)file);
                return Optional.empty();
            }
            return (Optional)CodecUtil.decodeJson((JsonElement)json, REGISTRY.get(id)).mapOrElse(Optional::of, err -> {
                LOGGER.error("Failed to parse data generator {}: {}", (Object)file, (Object)err.message());
                return Optional.empty();
            });
        }
        catch (JsonParseException | IOException e) {
            LOGGER.error("Failed to read data generator from file " + String.valueOf(file), e);
            return Optional.empty();
        }
    }

    public DataGenerator(boolean enabled, boolean startup, List<ResourceLocation> whitelist, Template path, DgRegistry<? extends DgEntry> registry, Template template) {
        ImmutableList immutable;
        this.enabled = enabled;
        this.startup = startup;
        this.whitelist = whitelist instanceof ImmutableList ? (immutable = (ImmutableList)whitelist) : ImmutableList.copyOf(whitelist);
        this.path = path;
        this.registry = registry;
        this.template = template;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Optional<Boolean> optionalEnabled() {
        return this.isEnabled() ? Optional.empty() : Optional.of(false);
    }

    public boolean isStartup() {
        return this.startup;
    }

    public Optional<Boolean> optionalStartup() {
        return this.isStartup() ? Optional.of(true) : Optional.empty();
    }

    public List<ResourceLocation> getWhitelist() {
        return this.whitelist;
    }

    public Optional<List<ResourceLocation>> optionalWhitelist() {
        return this.getWhitelist().isEmpty() ? Optional.empty() : Optional.of(this.getWhitelist());
    }

    public Template getPath() {
        return this.path;
    }

    public String getPath(DgEntry entry) {
        return this.getPath().parse(entry);
    }

    public DgRegistry<? extends DgEntry> getRegistry() {
        return this.registry;
    }

    public Template getTemplate() {
        return this.template;
    }

    public String getTemplate(DgEntry entry) {
        return this.getTemplate().parse(entry);
    }

    public void generate(PackHandler pack) {
        block4: {
            if (!this.isStartup() && !CropariaIf.isServerStarted()) break block4;
            if (this.getWhitelist().isEmpty()) {
                for (DgEntry dgEntry : this.getRegistry()) {
                    if (!dgEntry.shouldLoad()) continue;
                    this.generate(dgEntry, pack);
                }
            } else {
                for (ResourceLocation resourceLocation : this.getWhitelist()) {
                    this.getRegistry().forName(resourceLocation).ifPresent(e -> this.generate((DgEntry)e, pack));
                }
            }
        }
    }

    protected void generate(DgEntry entry, PackHandler pack) {
        String relative = this.getPath(entry);
        String replaced = this.getTemplate(entry);
        pack.cache(relative, replaced, this);
    }
}

