/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.generator.util;

import com.mojang.serialization.Codec;
import cool.muyucloud.croparia.api.generator.util.DgEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public interface DgRegistry<E extends DgEntry>
extends Iterable<E> {
    public static final Map<ResourceLocation, DgRegistry<?>> REGISTRY = new HashMap();
    public static final Map<DgRegistry<? extends DgEntry>, ResourceLocation> BY_INSTANCE = new HashMap<DgRegistry<? extends DgEntry>, ResourceLocation>();
    public static final Codec<DgRegistry<? extends DgEntry>> CODEC = ResourceLocation.CODEC.xmap(REGISTRY::get, BY_INSTANCE::get);

    public static <E extends DgEntry, T extends DgRegistry<E>> T register(ResourceLocation id, T iterable) {
        REGISTRY.put(id, iterable);
        BY_INSTANCE.put(iterable, id);
        return iterable;
    }

    public static <E extends DgEntry> DgRegistry<E> ofEnum(Class<E> enumClass) {
        return new EnumRegistry<E>(enumClass);
    }

    public static <E extends DgEntry> DgRegistry<E> ofMap(Map<ResourceLocation, E> map) {
        return new MapRegistry<E>(map);
    }

    default public Optional<E> forName(ResourceLocation id) {
        for (DgEntry e : this) {
            if (!e.getKey().equals((Object)id)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    default public ResourceLocation getId() {
        return BY_INSTANCE.get(this);
    }

    public static class EnumRegistry<E extends DgEntry>
    implements DgRegistry<E> {
        private final Map<ResourceLocation, E> map = new LinkedHashMap<ResourceLocation, E>();

        public EnumRegistry(Class<E> enumClass) {
            for (DgEntry e : (DgEntry[])enumClass.getEnumConstants()) {
                this.map.put(e.getKey(), e);
            }
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return this.map.values().iterator();
        }

        @Override
        public Optional<E> forName(ResourceLocation id) {
            return Optional.ofNullable((DgEntry)this.map.get(id));
        }
    }

    public static class MapRegistry<E extends DgEntry>
    implements DgRegistry<E> {
        private final Map<ResourceLocation, E> map;

        public MapRegistry(Map<ResourceLocation, E> map) {
            this.map = map;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return this.map.values().iterator();
        }

        @Override
        public Optional<E> forName(ResourceLocation name) {
            return Optional.ofNullable((DgEntry)this.map.get(name));
        }
    }
}

