/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.placeholder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public interface MapReader<K, V>
extends Iterable<Map.Entry<K, V>> {
    public static <K, V> MapReaderImpl<K, V> map(@NotNull Map<K, V> map) {
        return new MapReaderImpl<K, V>(map);
    }

    public static JsonObjectReader jsonObject(@NotNull JsonObject object) {
        return new JsonObjectReader(object);
    }

    public V get(K var1);

    public Collection<Map.Entry<K, V>> entries();

    default public Collection<K> keys() {
        return this.entries().stream().map(Map.Entry::getKey).toList();
    }

    default public Collection<V> values() {
        return this.entries().stream().map(Map.Entry::getValue).toList();
    }

    default public int size() {
        return this.entries().size();
    }

    @Override
    @NotNull
    default public Iterator<Map.Entry<K, V>> iterator() {
        return this.entries().iterator();
    }

    default public <K2, V2> Mapped<K, V, K2, V2> map(@NotNull Function<K, K2> keyMapper, @NotNull Function<K2, V2> getter) {
        return new Mapped(this, keyMapper, getter);
    }

    public static class MapReaderImpl<K, V>
    implements MapReader<K, V> {
        @NotNull
        private final Map<K, V> map;

        public MapReaderImpl(@NotNull Map<K, V> map) {
            this.map = map;
        }

        @NotNull
        public Map<K, V> get() {
            return this.map;
        }

        @Override
        public V get(K key) {
            return this.get().get(key);
        }

        @Override
        public Collection<Map.Entry<K, V>> entries() {
            return this.get().entrySet();
        }

        @Override
        public Collection<K> keys() {
            return this.get().keySet();
        }

        @Override
        public Collection<V> values() {
            return this.get().values();
        }
    }

    public static class JsonObjectReader
    implements MapReader<String, JsonElement> {
        private final JsonObject object;

        public JsonObjectReader(JsonObject object) {
            this.object = object;
        }

        public JsonObject get() {
            return this.object;
        }

        @Override
        public JsonElement get(String key) {
            return this.get().get(key);
        }

        @Override
        public Collection<Map.Entry<String, JsonElement>> entries() {
            return this.get().entrySet();
        }

        @Override
        public Collection<String> keys() {
            return this.get().keySet();
        }

        @Override
        public Collection<JsonElement> values() {
            return this.get().asMap().values();
        }
    }

    public record Mapped<KF, VF, K, V>(@NotNull MapReader<KF, VF> from, @NotNull Function<KF, K> keyMapper, @NotNull Function<K, V> getter) implements MapReader<K, V>
    {
        @Override
        public V get(K key) {
            return this.getter().apply(key);
        }

        @Override
        public int size() {
            return this.from().size();
        }

        @Override
        public Collection<Map.Entry<K, V>> entries() {
            return this.from().entries().stream().map(e -> new AbstractMap.SimpleEntry<K, V>(this.keyMapper.apply(e.getKey()), this.get(this.keyMapper().apply(e.getKey())))).toList();
        }

        @Override
        public Collection<K> keys() {
            return this.entries().stream().map(Map.Entry::getKey).toList();
        }

        @Override
        public Collection<V> values() {
            return this.entries().stream().map(Map.Entry::getValue).toList();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.from().entries().stream().map(e -> new AbstractMap.SimpleEntry<K, V>(this.keyMapper.apply(e.getKey()), this.get(this.keyMapper().apply(e.getKey())))).iterator();
        }
    }
}

