/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.placeholder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.placeholder.ListReader;
import cool.muyucloud.croparia.api.placeholder.MapReader;
import cool.muyucloud.croparia.api.placeholder.PatternKey;
import cool.muyucloud.croparia.api.placeholder.PlaceholderBuilder;
import cool.muyucloud.croparia.api.placeholder.PlaceholderException;
import cool.muyucloud.croparia.api.placeholder.PlaceholderFactory;
import cool.muyucloud.croparia.api.placeholder.RegexParser;
import cool.muyucloud.croparia.api.placeholder.TypeMapper;
import cool.muyucloud.croparia.api.recipe.entry.BlockOutput;
import cool.muyucloud.croparia.api.recipe.entry.ItemOutput;
import dev.architectury.extensions.injected.InjectedRegistryEntryExtension;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.Logger;

public class Placeholder<T>
implements RegexParser<T> {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Placeholder<String> STRING = Placeholder.build(node -> node.self(RegexParser.of(JsonPrimitive::new)));
    public static final Placeholder<Number> NUMBER = Placeholder.build(node -> node.self(RegexParser.of(JsonPrimitive::new)));
    public static final Placeholder<Boolean> BOOLEAN = Placeholder.build(node -> node.self(RegexParser.of(JsonPrimitive::new)));
    public static final Placeholder<JsonElement> JSON = Placeholder.build(builder -> {
        builder.self(RegexParser.of());
        builder.then(Pattern.compile("(^.*$)"), (entry, placeholder, matcher) -> {
            if (entry.isJsonArray()) {
                return JSON_ARRAY.parse(entry.getAsJsonArray(), matcher.group(1) + "." + placeholder, matcher);
            }
            if (entry.isJsonObject()) {
                return JSON_OBJECT.parse(entry.getAsJsonObject(), matcher.group(1) + "." + placeholder, matcher);
            }
            return Optional.empty();
        });
        return builder;
    });
    public static final Placeholder<JsonObject> JSON_OBJECT = Placeholder.buildMap(TypeMapper.of(MapReader::jsonObject), JSON, builder -> builder);
    public static final Placeholder<JsonArray> JSON_ARRAY = Placeholder.buildList(TypeMapper.of(ListReader::jsonArray), JSON, builder -> builder);
    public static final Placeholder<ResourceLocation> ID = Placeholder.build(node -> node.self(RegexParser.of(ResourceLocation::toString)).then(PatternKey.literal("namespace"), RegexParser.of(ResourceLocation::getNamespace)).then(PatternKey.literal("path"), RegexParser.of(ResourceLocation::getPath)));
    public static final Placeholder<DataComponentPatch> DATA_COMPONENTS = Placeholder.build(DataComponentPatch.CODEC, PlaceholderFactory.identity());
    public static final Placeholder<BlockOutput> BLOCK_OUTPUT = Placeholder.build(BlockOutput.CODEC, builder -> builder.then(PatternKey.literal("id"), TypeMapper.of(BlockOutput::getId), ID).thenMap(PatternKey.literal("properties"), TypeMapper.of((F block) -> MapReader.map(block.getProperties().getProperties())), STRING));
    public static final Placeholder<ItemOutput> ITEM_OUTPUT = Placeholder.build(ItemOutput.CODEC, builder -> builder.then(PatternKey.literal("id"), TypeMapper.of(ItemOutput::getId), ID).then(PatternKey.literal("amount"), TypeMapper.of(ItemOutput::getAmount), NUMBER).then(PatternKey.literal("components"), TypeMapper.of(ItemOutput::getComponentsPatch), DATA_COMPONENTS).then(PatternKey.literal("stack"), TypeMapper.of(ItemOutput::createStack), ItemStack.CODEC));
    public static final Placeholder<Item> ITEM = ID.map(TypeMapper.of(InjectedRegistryEntryExtension::arch$registryName));
    public static final Placeholder<ItemStack> ITEM_STACK = ITEM_OUTPUT.map(TypeMapper.of(ItemOutput::of));
    public static final Placeholder<Block> BLOCK = ID.map(TypeMapper.of(InjectedRegistryEntryExtension::arch$registryName));
    public static final Placeholder<BlockState> BLOCK_STATE = BLOCK_OUTPUT.map(TypeMapper.of(BlockOutput::of));
    private final @Unmodifiable Map<PatternKey, RegexParser<T>> subNodes;

    public static <T> Placeholder<T> build(Function<PlaceholderBuilder<T>, PlaceholderBuilder<T>> factory) {
        return factory.apply(PlaceholderBuilder.of()).build();
    }

    public static <T> Placeholder<T> build(Codec<T> codec, PlaceholderFactory<T> factory) {
        Placeholder<Object> json = JSON.map((entry, placeholder, matcher) -> Optional.ofNullable((JsonElement)CodecUtil.encodeJson(entry, codec).getOrThrow(PlaceholderException::new)));
        return factory.apply(PlaceholderBuilder.of()).concat(json, TypeMapper.identity()).build();
    }

    public static <T, V> Placeholder<T> buildMap(TypeMapper<T, MapReader<String, V>> mapper, Placeholder<V> valueParser, Function<PlaceholderBuilder<T>, PlaceholderBuilder<T>> factory) {
        return factory.apply(PlaceholderBuilder.ofMap(mapper, valueParser)).build();
    }

    public static <T, E> Placeholder<T> buildList(TypeMapper<T, ListReader<E>> mapper, Placeholder<E> valueParser, Function<PlaceholderBuilder<T>, PlaceholderBuilder<T>> factory) {
        return factory.apply(PlaceholderBuilder.ofList(mapper, valueParser)).build();
    }

    public Placeholder(Codec<T> codec, Function<PlaceholderBuilder<T>, PlaceholderBuilder<T>> factory) {
        Placeholder<Object> json = JSON.map((entry, placeholder, matcher) -> Optional.ofNullable((JsonElement)CodecUtil.encodeJson(entry, codec).getOrThrow(PlaceholderException::new)));
        this.subNodes = Collections.unmodifiableMap(factory.apply(PlaceholderBuilder.of()).concat(json, TypeMapper.identity()).getSubNodes());
    }

    public Placeholder(PlaceholderBuilder<T> builder) {
        this.subNodes = Collections.unmodifiableMap(builder.getSubNodes());
    }

    protected @Unmodifiable Map<PatternKey, RegexParser<T>> getSubNodes() {
        return this.subNodes;
    }

    public <O> Placeholder<O> map(TypeMapper<O, T> mapper) {
        PlaceholderBuilder<T> builder = PlaceholderBuilder.of();
        builder.overwrite(this, TypeMapper.identity());
        return new Placeholder<O>(builder.map(mapper));
    }

    @Override
    public Optional<JsonElement> parse(@NotNull T entry, @NotNull String placeholder, @NotNull Matcher matcher) throws PlaceholderException {
        String forwarded = RegexParser.forward(placeholder);
        String next = RegexParser.next(placeholder);
        for (Map.Entry<PatternKey, RegexParser<T>> subEntry : this.subNodes.entrySet()) {
            Optional<JsonElement> result;
            Matcher subMatcher = subEntry.getKey().pattern().matcher(next);
            if (!subMatcher.find() || !(result = subEntry.getValue().parse(entry, forwarded, subMatcher)).isPresent()) continue;
            return result;
        }
        throw new PlaceholderException("No matching key for: " + next);
    }

    public String parseStart(T entry, String placeholder, Matcher matcher) {
        try {
            JsonElement json = this.parse(entry, placeholder, matcher).orElseThrow(() -> new PlaceholderException("Unrecognized placeholder: " + placeholder));
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                return json.getAsString();
            }
            return json.toString();
        }
        catch (PlaceholderException e) {
            LOGGER.error("Error processing placeholder: " + placeholder, (Throwable)((Object)e));
            return "${" + placeholder + "}";
        }
    }
}

