/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.placeholder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.placeholder.ListReader;
import cool.muyucloud.croparia.api.placeholder.MapReader;
import cool.muyucloud.croparia.api.placeholder.PatternKey;
import cool.muyucloud.croparia.api.placeholder.Placeholder;
import cool.muyucloud.croparia.api.placeholder.PlaceholderException;
import cool.muyucloud.croparia.api.placeholder.RegexParser;
import cool.muyucloud.croparia.api.placeholder.TypeMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PlaceholderBuilder<T> {
    private final Map<PatternKey, RegexParser<T>> subNodes = new LinkedHashMap<PatternKey, RegexParser<T>>();

    public static <T> PlaceholderBuilder<T> of() {
        return new PlaceholderBuilder<T>();
    }

    public static <T> PlaceholderBuilder<T> of(Consumer<PlaceholderBuilder<T>> delegate) {
        PlaceholderBuilder<T> parser = new PlaceholderBuilder<T>();
        delegate.accept(parser);
        return parser;
    }

    public static <T, V> PlaceholderBuilder<T> ofMap(TypeMapper<T, @NotNull MapReader<String, V>> mapper, Placeholder<V> valueParser) {
        return PlaceholderBuilder.of(parser -> parser.self((entry, placeholder, matcher) -> {
            if (entry instanceof JsonObject) {
                JsonObject obj = (JsonObject)entry;
                return Optional.of(obj);
            }
            JsonObject obj = new JsonObject();
            mapper.map(entry, placeholder, matcher).ifPresent(map -> map.forEach(e -> valueParser.parse(e.getValue(), placeholder, matcher).ifPresent(v -> obj.add((String)e.getKey(), v))));
            return Optional.of(obj);
        }).then(PatternKey.literal("_size"), (T entry, String placeholder, Matcher matcher) -> mapper.map(entry, placeholder, matcher).map(MapReader::size), Placeholder.NUMBER).then(PatternKey.MAP_MAP_KEY, (T entry, String placeholder, Matcher matcher) -> {
            JsonObject obj = new JsonObject();
            mapper.map(entry, placeholder, matcher).ifPresent(map -> map.forEach(e -> valueParser.parse(e.getValue(), placeholder, matcher).ifPresent(k -> valueParser.parse(e.getValue(), "", PatternKey.EMPTY.matcher("")).ifPresent(v -> obj.add(k.getAsString(), v)))));
            return Optional.of(obj);
        }, Placeholder.JSON_OBJECT).then(PatternKey.MAP_MAP_VALUE, (T entry, String placeholder, Matcher matcher) -> {
            JsonObject obj = new JsonObject();
            mapper.map(entry, placeholder, matcher).ifPresent(map -> map.forEach(e -> valueParser.parse(e.getValue(), placeholder, matcher).ifPresent(v -> obj.add((String)e.getKey(), v))));
            return Optional.of(obj);
        }, Placeholder.JSON_OBJECT).then(PatternKey.literal("values()"), (T entry, String placeholder, Matcher matcher) -> {
            JsonArray array = new JsonArray();
            mapper.map(entry, placeholder, matcher).ifPresent(map -> map.values().forEach(value -> valueParser.parse(value, placeholder, matcher).ifPresent(arg_0 -> ((JsonArray)array).add(arg_0))));
            return Optional.of(array);
        }, Placeholder.JSON_ARRAY).then(PatternKey.literal("keys()"), (T entry, String placeholder, Matcher matcher) -> {
            JsonArray array = new JsonArray();
            mapper.map(entry, placeholder, matcher).ifPresent(map -> map.values().forEach(value -> valueParser.parse(value, placeholder, matcher).ifPresent(arg_0 -> ((JsonArray)array).add(arg_0))));
            return Optional.of(array);
        }, Placeholder.JSON_ARRAY).then(PatternKey.MAP_GET, (T entry, String placeholder, Matcher matcher) -> {
            String key = matcher.group(1);
            return mapper.map(entry, placeholder, matcher).map((? super T map) -> map.get(key)).flatMap(value -> valueParser.parse(value, placeholder, matcher));
        }).then(PatternKey.MAP_GET_OR, (T entry, String placeholder, Matcher matcher) -> {
            String key = matcher.group(1);
            String def = matcher.group(2);
            return mapper.map(entry, placeholder, matcher).map((? super T map) -> map.get(key)).flatMap(value -> valueParser.parse(value, placeholder, matcher)).or(() -> Optional.of(new JsonPrimitive(def)));
        }));
    }

    public static <T, E> PlaceholderBuilder<T> ofList(TypeMapper<T, ListReader<E>> mapper, Placeholder<E> elementParser) {
        return PlaceholderBuilder.of(parser -> parser.self((entry, placeholder, matcher) -> {
            if (entry instanceof JsonArray) {
                JsonArray array = (JsonArray)entry;
                return Optional.of(array);
            }
            JsonArray array = new JsonArray();
            mapper.map(entry, placeholder, matcher).ifPresent(list -> list.forEach(element -> elementParser.parse(element, placeholder, matcher).ifPresent(arg_0 -> ((JsonArray)array).add(arg_0))));
            return Optional.of(array);
        }).then(PatternKey.literal("_size"), (T entry, String placeholder, Matcher matcher) -> mapper.map(entry, placeholder, matcher).map(ListReader::size), Placeholder.NUMBER).then(PatternKey.LIST_MAP, (T entry, String placeholder, Matcher matcher) -> {
            JsonArray array = new JsonArray();
            Optional mayList = mapper.map(entry, placeholder, matcher);
            if (mayList.isEmpty()) {
                return Optional.of(array);
            }
            ListReader list = (ListReader)mayList.get();
            for (Object e : list) {
                elementParser.parse(e, placeholder, matcher).ifPresent(arg_0 -> ((JsonArray)array).add(arg_0));
            }
            return Optional.of(array);
        }, Placeholder.JSON_ARRAY).then(PatternKey.literal("mapi()"), (T entry, String placeholder, Matcher matcher) -> {
            JsonObject obj = new JsonObject();
            Optional mayList = mapper.map(entry, placeholder, matcher);
            if (mayList.isEmpty()) {
                return Optional.of(obj);
            }
            ListReader list = (ListReader)mayList.get();
            int i = 0;
            for (Object e : list) {
                Optional<JsonElement> mayValue = elementParser.parse(e, placeholder, matcher);
                if (mayValue.isPresent()) {
                    obj.add(String.valueOf(i), mayValue.get());
                }
                ++i;
            }
            return Optional.of(obj);
        }, Placeholder.JSON_OBJECT).then(PatternKey.LIST_GET, (T entry, String placeholder, Matcher matcher) -> {
            try {
                int index = Integer.parseInt(matcher.group(1).trim());
                Optional mayList = mapper.map(entry, placeholder, matcher);
                if (mayList.isEmpty()) {
                    return Optional.empty();
                }
                ListReader list = (ListReader)mayList.get();
                return list.size() > index ? elementParser.parse(list.get(index), placeholder, matcher) : Optional.empty();
            }
            catch (NumberFormatException e) {
                throw new PlaceholderException(e);
            }
            catch (IndexOutOfBoundsException e) {
                return Optional.empty();
            }
        }).then(PatternKey.LIST_GET_OR, (T entry, String placeholder, Matcher matcher) -> {
            String def = matcher.group(2).trim();
            try {
                int index = Integer.parseInt(matcher.group(1).trim());
                Optional mayList = mapper.map(entry, placeholder, matcher);
                if (mayList.isEmpty()) {
                    return Optional.empty();
                }
                ListReader list = (ListReader)mayList.get();
                return list.size() > index ? elementParser.parse(list.get(index), placeholder, matcher) : Optional.empty();
            }
            catch (NumberFormatException e) {
                throw new PlaceholderException(e);
            }
            catch (IndexOutOfBoundsException e) {
                return Optional.of(new JsonPrimitive(def));
            }
        }));
    }

    public PlaceholderBuilder() {
        this.then(PatternKey.QUOTE_IF_STR, (T entry, String placeholder, Matcher matcher) -> {
            RegexParser<Object> parser = this.subNodes.get(PatternKey.of(PatternKey.EMPTY));
            if (parser != null) {
                Optional<JsonElement> maySelf = parser.parse(entry, placeholder, matcher);
                if (maySelf.isEmpty()) {
                    return Optional.empty();
                }
                JsonElement self = maySelf.get();
                if (self.isJsonPrimitive() && self.getAsJsonPrimitive().isString()) {
                    return Optional.of(new JsonPrimitive(self.toString()));
                }
                return Optional.of(self);
            }
            return Optional.empty();
        });
        this.then(PatternKey.QUOTE, (T entry, String placeholder, Matcher matcher) -> {
            RegexParser<Object> parser = this.subNodes.get(PatternKey.of(PatternKey.EMPTY));
            if (parser != null) {
                Optional<JsonElement> maySelf = parser.parse(entry, placeholder, matcher);
                if (maySelf.isEmpty()) {
                    return Optional.empty();
                }
                JsonElement self = maySelf.get();
                if (self.isJsonPrimitive() && self.getAsJsonPrimitive().isString()) {
                    return Optional.of(new JsonPrimitive(self.toString()));
                }
                return Optional.of(new JsonPrimitive("\"" + String.valueOf(self) + "\""));
            }
            return Optional.empty();
        });
    }

    public PlaceholderBuilder(RegexParser<T> selfParser) {
        this.self(selfParser);
    }

    protected Map<PatternKey, RegexParser<T>> getSubNodes() {
        return this.subNodes;
    }

    @NotNull
    protected PlaceholderBuilder<T> self(@NotNull RegexParser<T> parser) {
        return this.then(PatternKey.EMPTY, parser);
    }

    @NotNull
    public <F> PlaceholderBuilder<T> self(TypeMapper<T, F> mapper, @NotNull Placeholder<F> parser) {
        return this.then(PatternKey.EMPTY, mapper, parser);
    }

    @NotNull
    public <F> PlaceholderBuilder<T> self(TypeMapper<T, F> mapper, @NotNull Codec<F> codec) {
        return this.then(PatternKey.EMPTY, mapper, codec);
    }

    @NotNull
    protected PlaceholderBuilder<T> then(@NotNull Pattern key, @NotNull RegexParser<T> parser) {
        this.subNodes.put(PatternKey.of(key), parser);
        return this;
    }

    @NotNull
    public <O> PlaceholderBuilder<T> then(@NotNull Pattern key, TypeMapper<T, O> mapper, @NotNull Placeholder<O> parser) {
        return this.then(key, (T entry, String placeholder, Matcher matcher) -> {
            Optional mayO = mapper.map(entry, placeholder, matcher);
            if (mayO.isEmpty()) {
                return Optional.empty();
            }
            Object o = mayO.get();
            return parser.parse(o, placeholder, matcher);
        });
    }

    @NotNull
    public <O> PlaceholderBuilder<T> then(@NotNull Pattern key, @NotNull TypeMapper<T, O> mapper, @NotNull Codec<O> codec) {
        return this.then(key, (T entry, String placeholder, Matcher matcher) -> {
            Optional mayO = mapper.map(entry, placeholder, matcher);
            if (mayO.isEmpty()) {
                return Optional.empty();
            }
            Object o = mayO.get();
            return (Optional)CodecUtil.encodeJson(o, codec).map(Optional::of).getOrThrow(PlaceholderException::new);
        }, Placeholder.JSON);
    }

    @NotNull
    public PlaceholderBuilder<T> then(@NotNull Pattern key, @NotNull Placeholder<T> parser) {
        this.subNodes.put(new PatternKey(key), parser);
        return this;
    }

    @NotNull
    public <V> PlaceholderBuilder<T> thenMap(@NotNull Pattern key, @NotNull TypeMapper<T, MapReader<String, V>> mapper, @NotNull Placeholder<V> valueParser) {
        return this.then(key, PlaceholderBuilder.ofMap(mapper, valueParser).build());
    }

    @NotNull
    public <E> PlaceholderBuilder<T> thenList(@NotNull Pattern key, @NotNull TypeMapper<T, ListReader<E>> mapper, @NotNull Placeholder<E> elemParser) {
        return this.then(key, PlaceholderBuilder.ofList(mapper, elemParser).build());
    }

    @NotNull
    public <O> PlaceholderBuilder<T> overwrite(@NotNull Placeholder<O> other, @NotNull TypeMapper<T, O> mapper) {
        for (Map.Entry entry : other.getSubNodes().entrySet()) {
            this.subNodes.put(entry.getKey(), (t, p, m) -> {
                Optional mayO = mapper.map(t, p, m);
                if (mayO.isEmpty()) {
                    return Optional.empty();
                }
                Object o = mayO.get();
                return ((RegexParser)entry.getValue()).parse(o, p, m);
            });
        }
        return this;
    }

    @NotNull
    public <O> PlaceholderBuilder<T> concat(@NotNull Placeholder<O> other, @NotNull TypeMapper<T, O> mapper) {
        for (Map.Entry entry : other.getSubNodes().entrySet()) {
            this.subNodes.putIfAbsent(entry.getKey(), (t, s, m) -> {
                Optional mayO = mapper.map(t, s, m);
                if (mayO.isEmpty()) {
                    return Optional.empty();
                }
                Object o = mayO.get();
                return ((RegexParser)entry.getValue()).parse(o, s, m);
            });
        }
        return this;
    }

    @NotNull
    public PlaceholderBuilder<T> remove(@NotNull Pattern key) {
        this.subNodes.remove(new PatternKey(key));
        return this;
    }

    public <O> PlaceholderBuilder<O> map(@NotNull TypeMapper<O, T> mapper) {
        PlaceholderBuilder<T> mapped = new PlaceholderBuilder<T>();
        for (Map.Entry<PatternKey, RegexParser<T>> entry : this.subNodes.entrySet()) {
            PatternKey key = entry.getKey();
            RegexParser parser = entry.getValue();
            mapped.subNodes.put(key, (oEntry, placeholder, matcher) -> mapper.map(oEntry, placeholder, matcher).flatMap(t -> parser.parse(t, placeholder, matcher)));
        }
        return mapped;
    }

    public Placeholder<T> build() {
        return new Placeholder(this);
    }
}

