/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.access.RecipeManagerAccess;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.api.recipe.network.S2CSyncClear;
import cool.muyucloud.croparia.api.recipe.network.S2CSyncRecipe;
import cool.muyucloud.croparia.registry.Recipes;
import cool.muyucloud.croparia.util.Ref;
import cool.muyucloud.croparia.util.SidedRef;
import cool.muyucloud.croparia.util.supplier.Mappable;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TypedSerializer<R extends DisplayableRecipe<?>>
extends RecipeBookCategory
implements RecipeType<R>,
RecipeSerializer<R> {
    public static final Codec<TypedSerializer<?>> CODEC = ResourceLocation.CODEC.xmap(Recipes::find, TypedSerializer::getId);
    public static Predicate<RecipeHolder<?>> JEI = holder -> Platform.isModLoaded((String)"jei") && !Platform.isModLoaded((String)"emi");
    public static Predicate<RecipeHolder<?>> NEVER = holder -> false;
    public static Predicate<RecipeHolder<?>> ALWAYS = holder -> true;
    private final ResourceLocation id;
    private final List<Mappable<ItemStack>> stations;
    private final Class<? extends R> recipeClass;
    private final MapCodec<R> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, R> streamCodec;
    private final transient RecipeDisplay.Type<R> displayType;
    private final transient Predicate<RecipeHolder<?>> syncFilter;
    private final transient Collection<R> synced = new HashSet<R>();

    @SafeVarargs
    public TypedSerializer(ResourceLocation id, Class<? extends R> recipeClass, MapCodec<R> codec, Predicate<RecipeHolder<?>> syncFilter, Mappable<ItemStack> ... stations) {
        this(id, recipeClass, codec, CodecUtil.toStream(codec.codec()), syncFilter, stations);
    }

    @SafeVarargs
    public TypedSerializer(ResourceLocation id, Class<? extends R> recipeClass, MapCodec<R> codec, StreamCodec<RegistryFriendlyByteBuf, R> streamCodec, Predicate<RecipeHolder<?>> syncFilter, Mappable<ItemStack> ... stations) {
        this.id = id;
        this.stations = new ArrayList<Mappable<ItemStack>>();
        this.stations.addAll(Arrays.asList(stations));
        this.recipeClass = recipeClass;
        this.codec = codec;
        this.streamCodec = streamCodec;
        this.syncFilter = syncFilter;
        this.displayType = new RecipeDisplay.Type(codec, streamCodec);
    }

    public <I extends RecipeInput, T extends DisplayableRecipe<I>> boolean shouldSync(RecipeHolder<T> holder) {
        if (((DisplayableRecipe)holder.value()).getTypedSerializer() == this) {
            return this.syncFilter.test(holder);
        }
        return false;
    }

    public <I extends RecipeInput, T extends DisplayableRecipe<I>> TypedSerializer<T> adapt() {
        return this;
    }

    public List<R> find() {
        ArrayList recipes = new ArrayList();
        SidedRef.ifServerOrElse(() -> CropariaIf.ifServer(server -> recipes.addAll(((RecipeManagerAccess)server.getRecipeManager()).cif$byType(this.adapt()).stream().map(holder -> (DisplayableRecipe)holder.value()).toList())), () -> recipes.addAll(this.getSyncedRecipes()));
        return recipes;
    }

    public <I extends RecipeInput> Optional<R> find(I input, Level level) {
        Ref result = new Ref();
        SidedRef.ifServerOrElse(() -> CropariaIf.ifServer(server -> result.set(server.getRecipeManager().getRecipeFor(this.adapt(), input, level).map(RecipeHolder::value).orElse(null))), () -> {
            TypedSerializer adapted = this.adapt();
            for (DisplayableRecipe recipe : adapted.synced) {
                if (!recipe.matches(input, level)) continue;
                result.set(recipe);
            }
        });
        return result.optional();
    }

    public void syncRecipes() {
        CropariaIf.ifServer(server -> {
            S2CSyncClear.of(this).send();
            ((RecipeManagerAccess)server.getRecipeManager()).cif$byType(this.adapt()).forEach(holder -> {
                if (this.shouldSync((RecipeHolder)holder)) {
                    SidedRef.ifClient(() -> this.adapt().recordRecipe((DisplayableRecipe)holder.value()));
                    S2CSyncRecipe.of((DisplayableRecipe)holder.value()).send();
                }
            });
        });
    }

    public void syncRecipes(@NotNull ServerPlayer player) {
        CropariaIf.ifServer(server -> {
            S2CSyncClear.of(this).send(player);
            ((RecipeManagerAccess)server.getRecipeManager()).cif$byType(this.adapt()).forEach(holder -> {
                if (this.shouldSync((RecipeHolder)holder)) {
                    SidedRef.ifClient(() -> this.adapt().recordRecipe((DisplayableRecipe)holder.value()));
                    S2CSyncRecipe.of((DisplayableRecipe)holder.value()).send(player);
                }
            });
        });
    }

    public Collection<R> getSyncedRecipes() {
        return this.synced;
    }

    public void recordRecipe(R recipe) {
        this.synced.add(recipe);
    }

    public void syncClear() {
        this.synced.clear();
    }

    public List<Mappable<ItemStack>> getStations() {
        return this.stations;
    }

    public void addStation(Mappable<ItemStack> station) {
        this.stations.add(station);
    }

    public Class<? extends R> getRecipeClass() {
        return this.recipeClass;
    }

    @NotNull
    public MapCodec<R> codec() {
        return this.codec;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
        return this.streamCodec;
    }

    @NotNull
    public RecipeDisplay.Type<R> displayType() {
        return this.displayType;
    }

    public ResourceLocation getId() {
        return this.id;
    }
}

