/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe.entry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.access.StateHolderAccess;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.codec.MultiCodec;
import cool.muyucloud.croparia.api.codec.TestedCodec;
import cool.muyucloud.croparia.api.core.component.BlockProperties;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlockOutput
implements SlotDisplay {
    public static final Codec<BlockOutput> CODEC_STR = ResourceLocation.CODEC.xmap(BlockOutput::create, BlockOutput::getId);
    public static final MapCodec<BlockOutput> CODEC_COMP = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(BlockOutput::getId), (App)BlockProperties.CODEC.optionalFieldOf("properties").forGetter(blockOutput -> Optional.of(blockOutput.getProperties()))).apply((Applicative)instance, (id, properties) -> BlockOutput.create(id, properties.orElse(BlockProperties.EMPTY))));
    public static final MultiCodec<BlockOutput> CODEC = CodecUtil.of(CodecUtil.of(CODEC_COMP.codec(), toEncode -> {
        if (toEncode.getProperties().isEmpty()) {
            return TestedCodec.fail(() -> "Can be encoded as string");
        }
        return TestedCodec.success();
    }), CODEC_STR);
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockOutput> STREAM_CODEC = CodecUtil.toStream(CODEC);
    public static final SlotDisplay.Type<BlockOutput> TYPE = new SlotDisplay.Type(CODEC_COMP, STREAM_CODEC);
    public static final ItemStack STACK_UNKNOWN = Items.BEDROCK.getDefaultInstance();
    public static final ItemStack STACK_AIR = Items.BARRIER.getDefaultInstance();
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private final BlockProperties properties;
    private final transient ItemStack displayStack;

    public static BlockOutput create(@NotNull ResourceLocation id) {
        return BlockOutput.create(id, BlockProperties.EMPTY);
    }

    protected static BlockOutput create(@NotNull ResourceLocation id, @NotNull BlockProperties properties) {
        return new BlockOutput(id, properties);
    }

    public static BlockOutput of(BlockState state) {
        return BlockOutput.create(Objects.requireNonNull(state.getBlock().arch$registryName()), BlockProperties.extract(state));
    }

    protected BlockOutput(@NotNull ResourceLocation id, @NotNull BlockProperties properties) {
        this.id = id;
        this.properties = properties;
        this.displayStack = BuiltInRegistries.BLOCK.getOptional(this.getId()).map(block -> {
            ItemStack stack = block.asItem().getDefaultInstance();
            stack.set(BlockProperties.TYPE, (Object)this.getProperties());
            return stack;
        }).orElseThrow(() -> new IllegalArgumentException("Unknown block: " + String.valueOf(id)));
    }

    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    public Block getBlock() {
        return BuiltInRegistries.BLOCK.getOptional(this.getId()).orElse(null);
    }

    @NotNull
    public BlockProperties getProperties() {
        return this.properties;
    }

    @NotNull
    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    public boolean matches(@NotNull Block block) {
        return Objects.equals(block.arch$registryName(), this.getId());
    }

    public boolean matches(@NotNull BlockState state) {
        return this.matches(state.getBlock()) && this.getProperties().isSubsetOf(state);
    }

    public void setBlock(ServerLevel level, BlockPos pos) {
        BlockState state = this.getBlock().defaultBlockState();
        state = StateHolderAccess.apply(state, this.getProperties());
        level.setBlock(pos, state, 3);
    }

    @NotNull
    public <T> Stream<T> resolve(ContextMap contextMap, DisplayContentsFactory<T> factory) {
        if (factory instanceof DisplayContentsFactory.ForStacks) {
            DisplayContentsFactory.ForStacks forStacks = (DisplayContentsFactory.ForStacks)factory;
            return Stream.of(forStacks.forStack(this.getDisplayStack()));
        }
        return Stream.empty();
    }

    @NotNull
    public SlotDisplay.Type<? extends SlotDisplay> type() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockOutput)) {
            return false;
        }
        BlockOutput that = (BlockOutput)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.properties, that.properties) && Objects.equals(this.displayStack, that.displayStack);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.properties, this.displayStack);
    }

    static {
        STACK_AIR.set(DataComponents.CUSTOM_NAME, (Object)Texts.translatable("tooltip.croparia.air", new Object[0]));
    }
}

