/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe.entry;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.codec.MultiCodec;
import cool.muyucloud.croparia.api.codec.TestedCodec;
import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.api.recipe.entry.BlockInput;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.CifUtil;
import cool.muyucloud.croparia.util.TagUtil;
import cool.muyucloud.croparia.util.supplier.OnLoadSupplier;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemInput
implements SlotDisplay {
    public static final ItemInput EMPTY = new ItemInput(null, null, DataComponentPredicate.EMPTY, 0L);
    public static final Codec<ItemInput> CODEC_STR = Codec.STRING.xmap(s -> s.isEmpty() ? EMPTY : new ItemInput((String)s, 1), ItemInput::getTaggable);
    public static final MapCodec<ItemInput> CODEC_COMP = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("id").forGetter(ItemInput::getId), (App)TagKey.codec((ResourceKey)Registries.ITEM).optionalFieldOf("tag").forGetter(ItemInput::getTag), (App)DataComponentPredicate.CODEC.optionalFieldOf("components", (Object)DataComponentPredicate.EMPTY).forGetter(ItemInput::getComponentsPredicate), (App)Codec.LONG.optionalFieldOf("amount", (Object)1L).forGetter(ItemInput::getAmount)).apply((Applicative)instance, (id, tag, components, amount) -> id.isEmpty() && tag.isEmpty() && components.equals((Object)DataComponentPredicate.EMPTY) || amount <= 0L ? EMPTY : new ItemInput(id.orElse(null), (TagKey<Item>)((TagKey)tag.orElse(null)), (DataComponentPredicate)components, (long)amount)));
    public static final MultiCodec<ItemInput> CODEC = CodecUtil.of(CodecUtil.of(CODEC_COMP.codec(), toEncode -> {
        if (toEncode.getComponentsPredicate().equals((Object)DataComponentPredicate.EMPTY) && toEncode.getAmount() == 1L || toEncode.equals(EMPTY)) {
            return TestedCodec.fail(() -> "Can be encoded as string");
        }
        return TestedCodec.success();
    }), CODEC_STR);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemInput> STREAM_CODEC = CodecUtil.toStream(CODEC);
    public static final SlotDisplay.Type<ItemInput> TYPE = new SlotDisplay.Type(CODEC_COMP, STREAM_CODEC);
    @Nullable
    private final ResourceLocation id;
    @Nullable
    private final TagKey<Item> tag;
    @NotNull
    private final DataComponentPredicate componentPredicate;
    private final long amount;
    private transient OnLoadSupplier<ImmutableList<ItemStack>> displayStacks;

    public static ItemInput of(ResourceLocation id) {
        return new ItemInput(id, null, DataComponentPredicate.EMPTY, 1L);
    }

    public static ItemInput ofTag(ResourceLocation id) {
        return new ItemInput(null, (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id), DataComponentPredicate.EMPTY, 1L);
    }

    public static ItemInput of(ItemStack stack) {
        DataComponentPredicate.Builder builder = DataComponentPredicate.builder();
        stack.getComponentsPatch().entrySet().forEach(entry -> ((Optional)entry.getValue()).ifPresent(value -> builder.expect(TypedDataComponent.createUnchecked((DataComponentType)((DataComponentType)entry.getKey()), (Object)value))));
        return new ItemInput(stack.getItem().arch$registryName(), null, builder.build(), stack.getCount());
    }

    public ItemInput(String s, int amount) {
        this(s.startsWith("#") ? null : ResourceLocation.parse((String)s), s.startsWith("#") ? TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)s.substring(1))) : null, DataComponentPredicate.EMPTY, amount);
    }

    public ItemInput(@NotNull ResourceLocation id, int amount) {
        this(id, null, DataComponentPredicate.EMPTY, amount);
    }

    public ItemInput(@NotNull ItemStack stack) {
        this(stack.getItem().arch$registryName(), null, CifUtil.extractPredicate(stack.getComponentsPatch()), stack.getCount());
    }

    public ItemInput(@Nullable ResourceLocation id, @Nullable TagKey<Item> tag, @NotNull DataComponentPredicate componentPredicate, long amount) {
        this.id = id;
        this.tag = tag;
        if (this.id != null && this.tag != null) {
            throw new IllegalArgumentException("id and tag cannot be set at the same time");
        }
        this.componentPredicate = componentPredicate;
        this.amount = amount;
        this.displayStacks = OnLoadSupplier.of(() -> {
            if (this.getId().isPresent()) {
                ItemStack stack = new ItemStack(Holder.direct((Object)((Item)BuiltInRegistries.ITEM.getValue(this.getId().get()))), Math.toIntExact(this.getAmount()), this.getComponentsPredicate().asPatch());
                if (stack.isEmpty()) {
                    DisplayableRecipe.LOGGER.error("Item with id '{}' not found, using placeholder", (Object)this.getId().get());
                    return ImmutableList.of((Object)Texts.tooltip(BlockInput.STACK_UNKNOWN.copy(), Texts.literal(this.getTaggable(), new Style[0])));
                }
                return ImmutableList.of((Object)stack);
            }
            if (this.getTag().isPresent()) {
                LinkedList stacks = new LinkedList();
                TagUtil.forEntries(this.getTag().get()).forEach(entry -> {
                    ItemStack stack = new ItemStack(entry, (int)Math.min(this.getAmount(), Integer.MAX_VALUE), this.getComponentsPredicate().asPatch());
                    stacks.addLast(stack);
                });
                if (stacks.isEmpty()) {
                    DisplayableRecipe.LOGGER.error("Item tag with id '{}' is empty, using placeholder", (Object)this.getTag().get().location());
                    return ImmutableList.of((Object)Texts.tooltip(BlockInput.STACK_UNKNOWN.copy(), Texts.literal(this.getTaggable(), new Style[0])));
                }
                return ImmutableList.copyOf(stacks);
            }
            ItemStack stack = new ItemStack(Holder.direct((Object)((Item)CropariaItems.PLACEHOLDER.get())), (int)Math.min(this.getAmount(), Integer.MAX_VALUE), this.getComponentsPredicate().asPatch());
            return ImmutableList.of((Object)stack);
        });
    }

    public String getTaggable() {
        return this.getTag().map(tag -> "#" + String.valueOf(tag.location())).orElseGet(() -> this.getId().map(ResourceLocation::toString).orElse(""));
    }

    public Optional<ResourceLocation> getId() {
        return Optional.ofNullable(this.id);
    }

    public ResourceLocation getDisplayId() {
        return this.getTag().map(TagKey::location).orElse(((ItemStack)this.getDisplayStacks().getFirst()).getItem().arch$registryName());
    }

    public Optional<TagKey<Item>> getTag() {
        return Optional.ofNullable(this.tag);
    }

    @NotNull
    public DataComponentPredicate getComponentsPredicate() {
        return this.componentPredicate;
    }

    public Optional<DataComponentPredicate> optionalComponents() {
        if (this.componentPredicate == DataComponentPredicate.EMPTY) {
            return Optional.empty();
        }
        return Optional.of(this.componentPredicate);
    }

    public long getAmount() {
        return this.amount;
    }

    public ImmutableList<ItemStack> getDisplayStacks() {
        return this.displayStacks.get();
    }

    public void mapStacks(Function<ImmutableList<ItemStack>, ImmutableList<ItemStack>> mapper) {
        this.displayStacks = this.displayStacks.map(mapper);
    }

    public boolean matches(@NotNull Item item) {
        if (this.getId().isPresent()) {
            return this.getId().get().equals((Object)item.arch$registryName());
        }
        if (this.getTag().isPresent()) {
            return TagUtil.isIn(this.getTag().get(), item);
        }
        return true;
    }

    public boolean matches(@NotNull DataComponentMap components) {
        return this.getComponentsPredicate().test(components);
    }

    public boolean matches(@NotNull ItemSpec item) {
        return this.matches(item.getResource()) && this.matches(item.getComponents());
    }

    public boolean matches(@NotNull ItemStack stack) {
        return this.matchType(stack) && this.getAmount() <= (long)stack.getCount();
    }

    public boolean matchType(@NotNull ItemStack stack) {
        return this.matches(stack.getItem()) && this.matches(stack.getComponents());
    }

    public boolean matches(@NotNull ItemSpec item, long amount) {
        return this.matches(item) && this.getAmount() <= amount;
    }

    @NotNull
    public <T> Stream<T> resolve(ContextMap contextMap, DisplayContentsFactory<T> factory) {
        if (factory instanceof DisplayContentsFactory.ForStacks) {
            DisplayContentsFactory.ForStacks forStacks = (DisplayContentsFactory.ForStacks)factory;
            return this.getDisplayStacks().stream().map(arg_0 -> ((DisplayContentsFactory.ForStacks)forStacks).forStack(arg_0));
        }
        return Stream.empty();
    }

    @NotNull
    public SlotDisplay.Type<? extends SlotDisplay> type() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ItemInput)) {
            return false;
        }
        ItemInput itemInput = (ItemInput)o;
        return this.amount == itemInput.amount && Objects.equals(this.id, itemInput.id) && Objects.equals(this.tag, itemInput.tag) && Objects.equals(this.componentPredicate, itemInput.componentPredicate) && Objects.equals(this.displayStacks, itemInput.displayStacks);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tag, this.componentPredicate, this.amount, this.displayStacks);
    }
}

