/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.repo.neoforge;

import cool.muyucloud.croparia.api.repo.Repo;
import cool.muyucloud.croparia.api.repo.platform.PlatformItemProxy;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class PlatformItemProxyImpl
implements PlatformItemProxy {
    private final IItemHandler handler;

    public static PlatformItemProxyImpl of(IItemHandler handler) {
        return new PlatformItemProxyImpl(handler);
    }

    public PlatformItemProxyImpl(IItemHandler handler) {
        this.handler = handler;
    }

    public IItemHandler get() {
        return this.handler;
    }

    @Override
    public Optional<Repo<ItemSpec>> peel() {
        Optional<Repo<ItemSpec>> optional;
        IItemHandler iItemHandler = this.get();
        if (iItemHandler instanceof Repo) {
            Repo repo = (Repo)iItemHandler;
            optional = Optional.of(repo);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public int size() {
        return this.get().getSlots();
    }

    @Override
    public boolean isEmpty(int i) {
        return this.get().getStackInSlot(i).isEmpty();
    }

    @Override
    public long simConsume(int i, ItemSpec item, long amount) {
        ItemStack stored = this.get().getStackInSlot(i);
        if (item.is(stored)) {
            return this.get().extractItem(i, (int)Math.min(amount, (long)stored.getCount()), true).getCount();
        }
        return 0L;
    }

    @Override
    public long consume(int i, ItemSpec item, long amount) {
        ItemStack stored = this.get().getStackInSlot(i);
        if (item.is(stored)) {
            return this.get().extractItem(i, (int)Math.min(amount, (long)stored.getCount()), false).getCount();
        }
        return 0L;
    }

    @Override
    public long simAccept(int i, ItemSpec item, long amount) {
        return this.get().insertItem(i, item.createStack(amount), true).getCount();
    }

    @Override
    public long accept(int i, ItemSpec item, long amount) {
        return this.get().insertItem(i, item.createStack(amount), false).getCount();
    }

    @Override
    public long capacityFor(int i, ItemSpec item) {
        ItemStack stored = this.get().getStackInSlot(i);
        if (stored.isEmpty() && this.get().insertItem(i, item.createStack(1L), true).getCount() == 1 || item.is(stored)) {
            return this.get().getSlotLimit(i);
        }
        return 0L;
    }

    @Override
    public long amountFor(int i, ItemSpec item) {
        ItemStack stored = this.get().getStackInSlot(i);
        if (item.is(stored)) {
            return stored.getCount();
        }
        return 0L;
    }

    @Override
    public ItemSpec resourceFor(int i) {
        return ItemSpec.of(this.get().getStackInSlot(i));
    }
}

