/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.compat.rei.category;

import cool.muyucloud.croparia.api.core.item.Placeholder;
import cool.muyucloud.croparia.api.core.recipe.RitualStructure;
import cool.muyucloud.croparia.api.recipe.TypedSerializer;
import cool.muyucloud.croparia.api.recipe.entry.BlockInput;
import cool.muyucloud.croparia.compat.rei.category.ReiCategory;
import cool.muyucloud.croparia.compat.rei.util.ReiDisplay;
import cool.muyucloud.croparia.compat.rei.util.ReiType;
import cool.muyucloud.croparia.compat.rei.util.ReiUtil;
import cool.muyucloud.croparia.compat.rei.widget.Item2DWidget;
import cool.muyucloud.croparia.compat.rei.widget.PatchedOverflow;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.Constants;
import cool.muyucloud.croparia.util.supplier.LazySupplier;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

public class ReiRitualStructure
extends ReiCategory<RitualStructure> {
    private static final LazySupplier<ItemStack> INPUT = LazySupplier.of(() -> {
        ItemStack stack = ((Placeholder)((Object)((Object)CropariaItems.PLACEHOLDER.get()))).getDefaultInstance();
        stack.set(DataComponents.CUSTOM_NAME, (Object)Texts.translatable("tooltip.croparia.input", new Object[0]));
        return stack;
    });
    public static final int SLOT_SIZE = 18;
    public static final int LABEL_MARGIN = 6;
    public static final int FRAME_PADDING = 9;
    public static final int BUTTON_SIZE = 10;

    public ReiRitualStructure(ReiType<RitualStructure> proxy) {
        super(proxy);
    }

    @Override
    public Renderer getIcon() {
        return EntryStacks.of((ItemStack)((BlockItem)CropariaItems.RITUAL_STAND.get()).getDefaultInstance());
    }

    @Override
    public TypedSerializer<RitualStructure> getRecipeType() {
        return RitualStructure.TYPED_SERIALIZER;
    }

    public List<Widget> setupDisplay(ReiDisplay<RitualStructure> display, Rectangle bounds) {
        RitualStructure recipe = display.getRecipe();
        AtomicInteger y = new AtomicInteger();
        Vec3i slotSize = display.getRecipe().size();
        Rectangle layerBound = new Rectangle(bounds.x + 9, bounds.y + 9, bounds.width - 18, bounds.height - 18 - 18);
        Panel background = Widgets.createSlotBase((Rectangle)new Rectangle(layerBound.x - 1, layerBound.y - 1, layerBound.width + 2, layerBound.height + 2));
        Button lower = Widgets.createButton((Rectangle)new Rectangle(bounds.x + 9, bounds.y + bounds.height - 9 - 14, 10, 10), (Component)Texts.literal("<", new Style[0])).onClick(button -> {
            if (y.get() > 0) {
                y.getAndDecrement();
            }
        }).tooltipLine((Component)Constants.RITUAL_STRUCTURE_LOWER);
        Button upper = Widgets.createButton((Rectangle)new Rectangle(bounds.x + bounds.width - 9 - 10, bounds.y + bounds.height - 9 - 14, 10, 10), (Component)Texts.literal(">", new Style[0])).onClick(button -> {
            if (y.get() < ((RitualStructure)display.getRecipe()).size().getY() - 1) {
                y.getAndIncrement();
            }
        }).tooltipLine((Component)Constants.RITUAL_STRUCTURE_UPPER);
        Widget label = Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> Widgets.createLabel((Point)new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height - 9 - 18 + 6), (Component)Texts.translatable("gui.croparia.ritual_structure.label", y.get() + 1)).render(graphics, mouseX, mouseY, delta));
        ArrayList<Item2DWidget> layers = new ArrayList<Item2DWidget>(slotSize.getY());
        int i = 0;
        while (i < slotSize.getY()) {
            int finalI = i++;
            layers.add(Item2DWidget.create().items((posX, posZ) -> {
                char c = recipe.getPattern().get((int)posX, finalI, (int)posZ);
                if (c == '.') {
                    return Collections.singleton(EntryStacks.of((ItemStack)BlockInput.STACK_AIR));
                }
                if (c == '$') {
                    return Collections.singleton(EntryStacks.of((ItemStack)INPUT.get()));
                }
                if (c == '*') {
                    return ReiUtil.toIngredient(recipe.getRitual());
                }
                if (c == ' ') {
                    return Collections.singleton(EntryStacks.of((ItemStack)BlockInput.STACK_ANY));
                }
                return ReiUtil.toIngredient(recipe.getKeys().get(Character.valueOf(c)));
            }).cols(slotSize.getX()).rows(slotSize.getZ()));
        }
        PatchedOverflow layer = new PatchedOverflow(new Rectangle(bounds.x + 9, bounds.y + 9, bounds.width - 18, bounds.height - 18 - 18), Widgets.delegateWithBounds(() -> (WidgetWithBounds)layers.get(y.get())));
        return List.of(background, lower, upper, label, layer);
    }

    public int getDisplayHeight() {
        return super.getDisplayHeight() * 2 + 18;
    }
}

