/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.mixin;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.access.StateHolderAccess;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StateHolder.class})
public abstract class StateHolderMixin<O, S>
implements StateHolderAccess<S> {
    @Shadow
    @Final
    private Reference2ObjectArrayMap<Property<?>, Comparable<?>> values;
    @Unique
    private Map<String, Property<?>> croparia_if$properties;

    @Shadow
    public abstract <T extends Comparable<T>, V extends T> S setValue(Property<T> var1, V var2);

    @Inject(method={"<init>(Ljava/lang/Object;Lit/unimi/dsi/fastutil/objects/Reference2ObjectArrayMap;Lcom/mojang/serialization/MapCodec;)V"}, at={@At(value="TAIL")})
    private void onConstruct(@Nullable O object, Reference2ObjectArrayMap<Property<?>, Comparable<?>> map, @Nullable MapCodec<S> mapCodec, @Nullable CallbackInfo ci) {
        if (map == null) {
            this.croparia_if$properties = ImmutableMap.of();
            return;
        }
        HashMap<String, Property> properties = new HashMap<String, Property>();
        for (Property property : map.keySet()) {
            properties.put(property.getName(), property);
        }
        this.croparia_if$properties = ImmutableMap.copyOf(properties);
    }

    @Override
    public Property<?> cif$getProperty(String key) {
        return this.croparia_if$properties.get(key);
    }

    @Override
    public String cif$getValue(String key) {
        Property<?> property = this.cif$getProperty(key);
        Comparable value = (Comparable)this.values.get(property);
        if (value == null) {
            return null;
        }
        if (value instanceof StringRepresentable) {
            StringRepresentable enumVal = (StringRepresentable)value;
            return enumVal.getSerializedName();
        }
        return value.toString();
    }

    @Override
    @Unique
    public <P extends Comparable<P>> S cif$setValue(String key, String value) {
        Property<?> property = this.cif$getProperty(key);
        Class cls = property.getValueClass();
        try {
            if (Integer.class.isAssignableFrom(cls)) {
                Property<?> intProp = property;
                return this.setValue(intProp, Integer.parseInt(value));
            }
            if (Boolean.class.isAssignableFrom(cls)) {
                Property<?> boolProp = property;
                return this.setValue(boolProp, Boolean.parseBoolean(value));
            }
            if (String.class.isAssignableFrom(cls)) {
                Property<?> stringProp = property;
                return this.setValue(stringProp, value);
            }
            if (StringRepresentable.class.isAssignableFrom(cls)) {
                for (Comparable p : property.getPossibleValues()) {
                    StringRepresentable enumVal = (StringRepresentable)p;
                    if (!enumVal.getSerializedName().equals(value)) continue;
                    return this.setValue(property, p);
                }
                return (S)this;
            }
            throw new UnsupportedOperationException("Property %s of type %s is not supported".formatted(key, cls));
        }
        catch (ClassCastException e) {
            CropariaIf.LOGGER.error("Failed to set property %s to %s".formatted(key, value), (Throwable)e);
            return (S)this;
        }
    }

    @Override
    public Map<String, String> cif$getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : this.croparia_if$properties.keySet()) {
            map.put(key, this.cif$getValue(key));
        }
        return map;
    }
}

