/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.util;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CifUtil {
    public static ResourceLocation formatId(String pattern, ResourceLocation id) {
        return ResourceLocation.tryBuild((String)id.getNamespace(), (String)pattern.formatted(id.getPath()));
    }

    public static boolean allNull(Object ... objects) {
        return Arrays.stream(objects).allMatch(Objects::isNull);
    }

    public static boolean isEdible(ItemStack item) {
        return item.has(DataComponents.FOOD);
    }

    @Nullable
    public static FoodProperties getFoodProperties(ItemStack item) {
        if (CifUtil.isEdible(item)) {
            return (FoodProperties)item.get(DataComponents.FOOD);
        }
        return null;
    }

    public static ServerLevel getLevel(ResourceLocation id, MinecraftServer server) {
        return server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id));
    }

    public static BlockPos lookingAt(@NotNull Player player) {
        Level world = player.level();
        ClipContext context = new ClipContext(player.getEyePosition(), player.getEyePosition().add(player.getLookAngle().multiply(5.0, 5.0, 5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult result = world.clip(context);
        return result.getBlockPos();
    }

    public static ItemStack transferItemNear(Level world, BlockPos pos, ItemStack stack) {
        for (Direction d : Direction.values()) {
            BlockEntity neighbor = world.getBlockEntity(pos.offset(d.getUnitVec3i()));
            if (!(neighbor instanceof Container)) continue;
            Container container = (Container)neighbor;
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack containerItem = container.getItem(i);
                if (containerItem.isEmpty()) {
                    container.setItem(i, stack);
                    return ItemStack.EMPTY;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)containerItem, (ItemStack)stack)) continue;
                int space = containerItem.getMaxStackSize() - containerItem.getCount();
                int count = Math.min(stack.getCount(), space);
                containerItem.setCount(containerItem.getCount() + count);
                stack.shrink(count);
            }
        }
        return stack;
    }

    public static void exportItem(Level world, BlockPos pos, ItemStack stack, @Nullable Player player) {
        ItemStack remain = CifUtil.transferItemNear(world, pos, stack);
        if (remain.isEmpty()) {
            return;
        }
        if (player != null) {
            player.addItem(remain);
        }
        world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, remain, 0.0, 0.0, 0.0));
    }

    public static DataComponentPredicate extractPredicate(DataComponentPatch patch) {
        DataComponentPredicate.Builder builder = DataComponentPredicate.builder();
        patch.entrySet().forEach(entry -> builder.expect(TypedDataComponent.createUnchecked((DataComponentType)((DataComponentType)entry.getKey()), entry.getValue())));
        return builder.build();
    }
}

