/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.util;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.util.supplier.LazySupplier;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;

public class SidedRef<T> {
    private final LazySupplier<T> value;
    private final Env side;

    public static Supplier<Minecraft> getClient() {
        return SidedRef.ifSide(Env.CLIENT, () -> Minecraft.getInstance());
    }

    public static Optional<MinecraftServer> getServer() {
        return CropariaIf.getServer();
    }

    public static boolean ifSideOrElse(Env side, Runnable run, Runnable orElse) {
        if (Platform.getEnvironment() == side) {
            run.run();
            return true;
        }
        orElse.run();
        return false;
    }

    public static <T> Supplier<T> ifSideOrElse(Env side, Supplier<T> supplier, Supplier<T> orElse) {
        if (Platform.getEnvironment() == side) {
            return supplier;
        }
        return orElse;
    }

    public static boolean ifSide(Env side, Runnable run) {
        return SidedRef.ifSideOrElse(side, run, () -> {});
    }

    public static <T> Supplier<T> ifSide(Env side, Supplier<T> run) {
        return SidedRef.ifSideOrElse(side, run, () -> null);
    }

    public static void ifServerOrElse(Runnable run, Runnable orElse) {
        SidedRef.ifSideOrElse(Env.SERVER, run, orElse);
    }

    public static <T> Supplier<T> ifServerOrElse(Supplier<T> run, Supplier<T> orElse) {
        return SidedRef.ifSideOrElse(Env.SERVER, run, orElse);
    }

    public static boolean ifServer(Runnable run) {
        return SidedRef.ifSide(Env.SERVER, run);
    }

    public static <T> Supplier<T> ifServer(Supplier<T> run) {
        return SidedRef.ifSide(Env.SERVER, run);
    }

    public static boolean ifClientOrElse(Runnable run, Runnable orElse) {
        return SidedRef.ifSideOrElse(Env.CLIENT, run, orElse);
    }

    public static <T> Supplier<T> ifClientOrElse(Supplier<T> run, Supplier<T> orElse) {
        return SidedRef.ifSideOrElse(Env.CLIENT, run, orElse);
    }

    public static boolean ifClient(Runnable run) {
        return SidedRef.ifSide(Env.CLIENT, run);
    }

    public static <T> Supplier<T> ifClient(Supplier<T> run) {
        return SidedRef.ifSide(Env.CLIENT, run);
    }

    public static <T> SidedRef<T> ofClient(Supplier<T> supplier) {
        return new SidedRef<T>(LazySupplier.of(supplier), Env.CLIENT);
    }

    public static <T> SidedRef<T> ofServer(Supplier<T> supplier) {
        return new SidedRef<T>(LazySupplier.of(supplier), Env.SERVER);
    }

    public SidedRef(LazySupplier<T> supplier, Env side) {
        this.value = supplier;
        this.side = side;
    }

    public boolean use(Consumer<T> consumer) {
        return SidedRef.ifSide(this.side, () -> consumer.accept(this.value.get()));
    }

    public boolean useOrElse(Consumer<T> consumer, Runnable orElse) {
        return SidedRef.ifSideOrElse(this.side, () -> consumer.accept(this.value.get()), orElse);
    }

    public T get() {
        return (T)this.getOrElse(() -> null);
    }

    public T getOrElse(Supplier<T> orElse) {
        return SidedRef.ifSideOrElse(this.side, this.value, orElse).get();
    }

    public boolean is(Env side) {
        return this.side == side;
    }
}

