/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.util;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public class TagUtil {
    public static <T> Optional<Registry<T>> getRegistry(ResourceKey<? extends Registry<T>> key) {
        Optional maybeRegistry = BuiltInRegistries.REGISTRY.getOptional(key.location());
        if (maybeRegistry.isEmpty()) {
            return Optional.empty();
        }
        try {
            if (key.equals((Object)((Registry)maybeRegistry.get()).key())) {
                Registry registry = (Registry)maybeRegistry.get();
                return Optional.of(registry);
            }
            return Optional.empty();
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    public static <T> Iterable<Holder<T>> forEntries(TagKey<T> tag) {
        return TagUtil.getRegistry(tag.registry()).map(registry -> registry.getTagOrEmpty(tag)).orElse(List.of());
    }

    public static <T> Iterable<Holder<T>> forEntries(ResourceKey<? extends Registry<T>> registry, ResourceLocation id) {
        return TagUtil.forEntries(TagKey.create(registry, (ResourceLocation)id));
    }

    public static <T> boolean isIn(ResourceKey<? extends Registry<T>> registry, ResourceLocation id, @NotNull T entry) {
        return TagUtil.isIn(TagKey.create(registry, (ResourceLocation)id), entry);
    }

    public static <T> boolean isIn(@NotNull TagKey<T> tagKey, @NotNull T entry) {
        Optional<Registry<T>> maybeRegistry = TagUtil.getRegistry(tagKey.registry());
        if (maybeRegistry.isEmpty()) {
            return false;
        }
        Registry registry = maybeRegistry.get();
        Optional maybeKey = registry.getResourceKey(entry);
        return maybeKey.map(tResourceKey -> registry.getOrThrow(tResourceKey).is(tagKey)).orElse(false);
    }
}

