/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.util.supplier;

import cool.muyucloud.croparia.util.supplier.LazySupplier;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.DeferredSupplier;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class HolderSupplier<T>
implements DeferredSupplier<T> {
    @NotNull
    private final ResourceKey<? super T> key;
    @NotNull
    private final Registry<? super T> registry;
    @NotNull
    private final LazySupplier<T> value;

    public static <T> HolderSupplier<T> of(Supplier<T> value, ResourceLocation location, Registry<? super T> registry) {
        return new HolderSupplier<T>(value, ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)location));
    }

    public static <S, T extends S> HolderSupplier<T> of(Supplier<T> value, ResourceLocation location, ResourceKey<Registry<S>> registry) {
        return new HolderSupplier<T>(value, ResourceKey.create(registry, (ResourceLocation)location));
    }

    public HolderSupplier(@NotNull Supplier<T> value, @NotNull ResourceKey<? super T> key) {
        this.value = LazySupplier.of(value);
        this.key = key;
        this.registry = (Registry)BuiltInRegistries.REGISTRY.getValue(this.getRegistryId());
        if (this.registry == null) {
            throw new IllegalArgumentException("Invalid registry id: " + String.valueOf(this.getRegistryId()));
        }
    }

    @NotNull
    public ResourceKey<T> getKey() {
        return this.key;
    }

    @NotNull
    public Registry<? super T> getRegistry() {
        return this.registry;
    }

    public ResourceLocation getRegistryId() {
        return this.getKey().registry();
    }

    public ResourceKey<Registry<T>> getRegistryKey() {
        return this.getRegistry().key();
    }

    public ResourceLocation getId() {
        return this.getKey().location();
    }

    public boolean isPresent() {
        return this.getRegistry().containsKey(this.getId());
    }

    public T get() {
        return (T)this.getRegistry().getValue(this.getId());
    }

    public void register() {
        DeferredRegister register = DeferredRegister.create((String)this.getId().getNamespace(), this.getRegistryKey());
        register.register(this.getId().getPath(), this.value);
        register.register();
    }

    public boolean tryRegister() {
        try {
            this.register();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }
}

