/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.util.text;

import cool.muyucloud.croparia.api.core.component.Text;
import cool.muyucloud.croparia.registry.CropariaComponents;
import cool.muyucloud.croparia.util.text.FailureMessenger;
import cool.muyucloud.croparia.util.text.SuccessMessenger;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Texts {
    public static ItemStack rename(Item item, Component name) {
        return Texts.rename(item.getDefaultInstance(), name);
    }

    public static ItemStack rename(ItemStack stack, Component name) {
        stack.set(DataComponents.CUSTOM_NAME, (Object)name);
        return stack;
    }

    public static ItemStack tooltip(Item item, MutableComponent component) {
        return Texts.tooltip(item.getDefaultInstance(), component);
    }

    public static ItemStack tooltip(ItemStack stack, MutableComponent component) {
        Text text = (Text)stack.getOrDefault((DataComponentType)CropariaComponents.TEXT.get(), (Object)new Text());
        text.append((Component)component);
        stack.set((DataComponentType)CropariaComponents.TEXT.get(), (Object)text);
        return stack;
    }

    public static MutableComponent literal(String text, Style ... styles) {
        return Texts.forStyles(Component.literal((String)text), styles);
    }

    public static MutableComponent literal() {
        return Texts.forStyles(Component.empty(), new Style[0]);
    }

    public static MutableComponent translatable(String key, Object ... args) {
        return Component.translatable((String)key, (Object[])args);
    }

    public static MutableComponent forStyles(@NotNull MutableComponent component, Style ... styles) {
        for (Style style : styles) {
            component.withStyle(style);
        }
        return component;
    }

    public static void chat(@NotNull Player player, Component message) {
        player.displayClientMessage(message, false);
    }

    public static void chat(@NotNull CommandSourceStack source, Component msg) {
        source.sendSystemMessage(msg);
    }

    public static void chat(@NotNull ClientCommandRegistrationEvent.ClientCommandSourceStack source, Component msg) {
        Texts.success(source, msg);
    }

    public static void overlay(@NotNull Player player, Component message) {
        player.displayClientMessage(message, true);
    }

    public static SuccessMessenger success(@NotNull CommandSourceStack source) {
        return (msg, broadcast) -> Texts.success(source, msg, broadcast);
    }

    public static SuccessMessenger success(@NotNull ClientCommandRegistrationEvent.ClientCommandSourceStack source) {
        return (msg, broadcast) -> Texts.success(source, msg, broadcast);
    }

    public static void success(@NotNull CommandSourceStack source, Component message, boolean broadcast) {
        source.sendSuccess(() -> message, broadcast);
    }

    public static void success(@NotNull CommandSourceStack source, Component message) {
        Texts.success(source, message, false);
    }

    public static void success(@NotNull ClientCommandRegistrationEvent.ClientCommandSourceStack source, Component message, boolean broadcast) {
        source.arch$sendSuccess(() -> message, broadcast);
    }

    public static void success(@NotNull ClientCommandRegistrationEvent.ClientCommandSourceStack source, Component message) {
        Texts.success(source, message, false);
    }

    public static void broadcastSuccess(@NotNull CommandSourceStack source, Component message) {
        source.sendSuccess(() -> message, true);
    }

    public static void broadcastSuccess(@NotNull ClientCommandRegistrationEvent.ClientCommandSourceStack source, Component message) {
        source.arch$sendSuccess(() -> message, true);
    }

    public static FailureMessenger failure(@NotNull CommandSourceStack source) {
        return msg -> Texts.failure(source, msg);
    }

    public static FailureMessenger failure(@NotNull ClientCommandRegistrationEvent.ClientCommandSourceStack source) {
        return msg -> Texts.failure(source, msg);
    }

    public static void failure(@NotNull CommandSourceStack source, Component message) {
        source.sendFailure(message);
    }

    public static void failure(@NotNull ClientCommandRegistrationEvent.ClientCommandSourceStack source, Component message) {
        source.arch$sendFailure(message);
    }

    public static Style suggestCommand(String ... words) {
        if (words.length == 0) {
            return Style.EMPTY;
        }
        return Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, (words[0].startsWith("/") ? "" : "/") + String.join((CharSequence)" ", words)));
    }

    public static Style runCommand(String ... words) {
        if (words.length == 0) {
            return Style.EMPTY;
        }
        return Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, (words[0].startsWith("/") ? "" : "/") + String.join((CharSequence)" ", words)));
    }

    public static Style copyText(String text) {
        return Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text)).applyTo(Texts.hoverText((Component)Texts.translatable("commands.croparia.click2copy", text)));
    }

    public static Style openFile(String path) {
        return Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, path));
    }

    public static Style hoverItem(ResourceLocation id) {
        return Texts.hoverItem((Item)BuiltInRegistries.ITEM.getValue(id));
    }

    public static Style hoverItem(Item item) {
        return Texts.hoverItem(item.getDefaultInstance());
    }

    public static Style hoverItem(ItemStack stack) {
        return stack.isEmpty() ? Style.EMPTY : Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(stack)));
    }

    public static Style hoverText(String text) {
        return Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Texts.literal(text, new Style[0])));
    }

    public static Style hoverText(Component text) {
        return Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)text));
    }

    public static Style blockMouseBehavior() {
        return Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.WHITE);
    }

    public static Style inlineMouseBehavior() {
        return Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY);
    }
}

