/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia;

import com.mojang.logging.LogUtils;
import cool.muyucloud.croparia.api.core.command.CommonCommandRoot;
import cool.muyucloud.croparia.config.Config;
import cool.muyucloud.croparia.config.ConfigFileHandler;
import cool.muyucloud.croparia.registry.BlockEntities;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.registry.CropariaComponents;
import cool.muyucloud.croparia.registry.CropariaFluids;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.registry.Crops;
import cool.muyucloud.croparia.registry.DataGenerators;
import cool.muyucloud.croparia.registry.DgRegistries;
import cool.muyucloud.croparia.registry.NetworkHandlers;
import cool.muyucloud.croparia.registry.PackHandlers;
import cool.muyucloud.croparia.registry.PlacedFeatures;
import cool.muyucloud.croparia.registry.Recipes;
import cool.muyucloud.croparia.registry.SlotDisplays;
import cool.muyucloud.croparia.registry.Tabs;
import cool.muyucloud.croparia.util.Ref;
import cool.muyucloud.croparia.util.supplier.OnLoadSupplier;
import cool.muyucloud.croparia.util.text.Texts;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class CropariaIf {
    public static final Mod INSTANCE = Platform.getMod((String)"croparia");
    public static final String MOD_ID = "croparia";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Config CONFIG = ConfigFileHandler.load();
    private static Boolean SERVER_STARTED = false;
    private static MinecraftServer SERVER = null;

    public static void init() {
        OnLoadSupplier.LAST_DATA_LOAD = System.currentTimeMillis();
        LOGGER.info("=== Croparia common setup on %s ===".formatted(Platform.getEnvironment()));
        LOGGER.info("Croparia IF customize registration");
        DgRegistries.register();
        DataGenerators.register();
        PackHandlers.register();
        Crops.register();
        LOGGER.info("Croparia IF vanilla registration");
        NetworkHandlers.register();
        CropariaComponents.register();
        CropariaFluids.register();
        CropariaBlocks.register();
        BlockEntities.register();
        CropariaItems.register();
        SlotDisplays.register();
        Recipes.register();
        Tabs.register();
        CommonCommandRoot.register();
        PlacedFeatures.register();
        LOGGER.info("Croparia IF event registration");
        LifecycleEvent.SERVER_BEFORE_START.register(server -> {
            SERVER = server;
        });
        LifecycleEvent.SERVER_STARTING.register(server -> ConfigFileHandler.reload(CONFIG));
        LifecycleEvent.SERVER_STARTED.register(server -> {
            SERVER_STARTED = true;
            OnLoadSupplier.LAST_DATA_LOAD = System.currentTimeMillis();
            if (CONFIG.getAutoReload() >= 0) {
                LOGGER.info("Croparia IF is performing a datapack reload to apply data generators");
                server.method_3734().method_44252(server.method_3739(), "schedule function croparia:auto_reload %s".formatted(CONFIG.getAutoReload()));
            }
            if (INSTANCE.getVersion().contains("a") || INSTANCE.getVersion().contains("alpha")) {
                server.method_3760().method_14571().forEach(player -> player.method_64398((class_2561)Texts.translatable("chat.croparia.alpha_warning", Texts.literal(INSTANCE.getIssueTracker().orElse(""), new class_2583[0])).method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true)))));
            }
        });
        LifecycleEvent.SERVER_STOPPING.register(server -> {
            SERVER_STARTED = false;
            ConfigFileHandler.save(CONFIG);
        });
        LifecycleEvent.SERVER_STOPPED.register(server -> {
            SERVER = null;
        });
        LOGGER.info("=== Croparia common setup done ===");
    }

    public static Optional<MinecraftServer> getServer() {
        return Optional.ofNullable(SERVER);
    }

    public static void ifServerOrElse(Consumer<MinecraftServer> consumer, Runnable orElse) {
        if (SERVER != null) {
            consumer.accept(SERVER);
        } else {
            orElse.run();
        }
    }

    public static void ifServerOrClient(Consumer<MinecraftServer> serverConsumer, Consumer<Ref<class_310>> clientConsumer) {
        if (SERVER != null) {
            serverConsumer.accept(SERVER);
        } else if (Platform.getEnvironment() == Env.CLIENT) {
            clientConsumer.accept(Ref.of(class_310.method_1551()));
        }
    }

    public static void ifServer(Consumer<MinecraftServer> consumer) {
        if (SERVER != null) {
            consumer.accept(SERVER);
        }
    }

    public static void ifClientOrElse(Consumer<Ref<class_310>> consumer, Consumer<Optional<MinecraftServer>> orElse) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            consumer.accept(Ref.of(class_310.method_1551()));
        } else {
            orElse.accept(Optional.ofNullable(SERVER));
        }
    }

    public static void ifClient(Consumer<Ref<class_310>> consumer) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            consumer.accept(Ref.of(class_310.method_1551()));
        }
    }

    public static class_2960 of(String path) {
        class_2960 id = class_2960.method_43902((String)MOD_ID, (String)path);
        if (id == null) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        return id;
    }

    public static boolean isServerStarted() {
        return SERVER_STARTED;
    }

    public static Optional<class_5455> getRegistryAccess() {
        Ref accessRef = new Ref();
        CropariaIf.ifServerOrClient(server -> accessRef.set(server.method_30611()), ref -> {
            class_638 level = ((class_310)ref.get()).field_1687;
            if (level != null) {
                accessRef.set(level.method_30349());
            }
        });
        return Optional.ofNullable((class_5455)accessRef.get());
    }
}

