/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.block;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.entity.FakePlayer;
import cool.muyucloud.croparia.api.core.recipe.container.RitualContainer;
import cool.muyucloud.croparia.api.core.recipe.container.RitualStructureContainer;
import cool.muyucloud.croparia.api.core.util.DropsCache;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.registry.Recipes;
import cool.muyucloud.croparia.util.CifUtil;
import cool.muyucloud.croparia.util.ItemPlaceable;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.ArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class RitualStand
extends class_2248
implements ItemPlaceable {
    public static final Long CRAFT_INTERVAL = 1000L;
    protected static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.3, (double)0.0, (double)16.0, (double)6.0, (double)16.0);

    public RitualStand(class_4970.class_2251 properties) {
        super(properties);
    }

    @NotNull
    protected class_1269 method_55765(class_1799 itemStack, class_2680 blockState, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 blockHitResult) {
        if (hand == class_1268.field_5808) {
            if (itemStack.method_7909() == CropariaItems.RECIPE_WIZARD.get()) {
                return class_1269.field_5811;
            }
            this.placeItem(world, pos, itemStack, (class_1297)player);
            return class_1269.field_21466;
        }
        return super.method_55765(itemStack, blockState, world, pos, player, hand, blockHitResult);
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            if (CropariaIf.CONFIG.getRitual().booleanValue() && world instanceof class_3218) {
                class_3218 level = (class_3218)world;
                if (DropsCache.isQueried(world, pos, CRAFT_INTERVAL)) {
                    return;
                }
                DropsCache.mark((class_1937)level, pos);
                Recipes.RITUAL_STRUCTURE.find(new RitualStructureContainer(level.method_8320(pos)), (class_1937)level).map(structure -> structure.validate(pos, (class_1937)level)).ifPresentOrElse(r -> r.ifSuccessOrElse(matched -> {
                    RitualContainer matcher = RitualContainer.of(level.method_8320(pos), DropsCache.queryStacks(world, pos), matched);
                    Recipes.RITUAL.find(matcher, (class_1937)level).ifPresentOrElse(ritual -> {
                        class_1657 player;
                        class_1297 patt0$temp;
                        class_1799 result = ritual.assemble(matcher);
                        if (result.method_7909() instanceof class_1826) {
                            ArrayList<class_1799> remainders = FakePlayer.useAllItemsOn(level, pos, result);
                            for (class_1799 remainder : remainders) {
                                class_1657 player2;
                                if (remainder.method_7960()) continue;
                                class_1297 patt0$temp2 = itemEntity.method_24921();
                                CifUtil.exportItem((class_1937)level, pos, remainder, patt0$temp2 instanceof class_1657 ? (player2 = (class_1657)patt0$temp2) : null);
                            }
                        }
                        CifUtil.exportItem((class_1937)level, pos, result, (patt0$temp = itemEntity.method_24921()) instanceof class_1657 ? (player = (class_1657)patt0$temp) : null);
                        this.playSound(level, pos);
                    }, () -> this.tryTell(itemEntity, (class_2561)Texts.translatable("overlay.croparia.ritual.rejected", new Object[0])));
                }, () -> this.tryTell(itemEntity, (class_2561)Texts.translatable("overlay.croparia.ritual.bad", new Object[0]))), () -> this.tryTell(itemEntity, (class_2561)Texts.translatable("overlay.croparia.ritual.404", new Object[0])));
            }
        }
    }

    protected void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean movedByPiston) {
        super.method_9536(state, level, pos, newState, movedByPiston);
        DropsCache.remove(level, pos);
    }

    protected void tryTell(class_1542 drop, class_2561 msg) {
        class_1297 class_12972 = drop.method_24921();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (drop.method_19538().method_1022(player.method_19538()) < 10.0) {
                Texts.overlay(player, msg);
            }
        }
    }

    protected void playSound(@NotNull class_3218 level, @NotNull class_2338 pos) {
        level.method_45447(null, pos, class_3414.method_47908((class_2960)CropariaIf.of("block.ritual.craft")), class_3419.field_15245);
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @NotNull
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }
}

